/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.deliver.DeliverNewErpInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="30_deliver")
public class DeliverHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(DeliverHandle.class);
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private DeliverNewErpInterface deliverNewErpInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        long endTime;
        long time;
        long startTime = System.currentTimeMillis();
        logger.info("++++++++++++DeliverHandle+++++++++mallMainOrderVo={}", (Object)JSON.toJSONString((Object)mallMainOrderVo));
        if (this.tradeCommonInterface.isNoDeliverOrder(mallMainOrderVo)) {
            return BaseJsonVo.success((Object)"");
        }
        MallOrderCacheVo orderCacheVo = mallMainOrderVo.getOrderCacheVo();
        if (orderCacheVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK.getValue() || orderCacheVo.getOrderSource() == OrderSourceEnum.ACTIVE.getValue()) {
            return BaseJsonVo.success((Object)"");
        }
        if (orderCacheVo.getCacheType() == 2) {
            if (orderCacheVo.getDeliverDate() == null) {
                return BaseJsonVo.error((String)"\u6ca1\u6709\u9009\u62e9\u914d\u9001\u65e5\u671f");
            }
            if (DateUtils.dateTimeCompare((Date)orderCacheVo.getDeliverDate(), (Date)DateUtils.currentDate()) > 0L) {
                return BaseJsonVo.error((String)"\u914d\u9001\u65e5\u671f\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f");
            }
        }
        String[] err = new String[]{""};
        int loopCount = 0;
        Date deliverDate = mallMainOrderVo.getOrderCacheVo().getDeliverDate();
        Date deliverDate2 = mallMainOrderVo.getOrderCacheVo().getDeliverDate2();
        for (MallOrderVo c : mallMainOrderVo.getMallOrderVos()) {
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 1) {
                if (c.getOrderSource() != OrderSourceEnum.LONGPERIOD_BUY.getValue() || loopCount <= 0) {
                    c.setDeliverVo(this.deliverNewErpInterface.getDeliverByErp(c, mallMainOrderVo.getAddressVo(), DateUtils.formatDate((Date)deliverDate, (String)"yyyy-MM-dd"), mallMainOrderVo.getOrderCacheVo().getSpeedUp(), mallMainOrderVo.getOrderCacheVo().getCacheType()));
                }
            } else {
                if (c.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
                    if (loopCount > 0) {
                        deliverDate = DateUtils.getAddDateByDay((Date)deliverDate, (int)c.getDeliverPeriod());
                    }
                } else if (c.getSelfMadeType() == 2 && loopCount == 1) {
                    deliverDate = deliverDate2 != null ? deliverDate2 : deliverDate;
                }
                c.setDeliverVo(this.deliverNewErpInterface.getDeliverByErp(c, mallMainOrderVo.getAddressVo(), DateUtils.formatDate((Date)deliverDate, (String)"yyyy-MM-dd"), mallMainOrderVo.getOrderCacheVo().getSpeedUp(), mallMainOrderVo.getOrderCacheVo().getCacheType()));
                String saleOutProduct = "";
                if (c.getDeliverVo().getInventory() == 0) {
                    MallProductVO p;
                    List lst;
                    if (c.getProducts() != null) {
                        lst = c.getProducts().stream().filter(c1 -> c1.getSoldOut() == true).collect(Collectors.toList());
                        MallProductVO mallProductVO = p = lst.size() > 0 ? (MallProductVO)lst.get(0) : null;
                        if (p != null) {
                            saleOutProduct = p.getProNameSx();
                        }
                    }
                    if (c.getGroups() != null) {
                        MallGroupVO g;
                        lst = c.getGroups().stream().filter(c1 -> c1.getSoldOut() == true).collect(Collectors.toList());
                        MallGroupVO mallGroupVO = g = lst.size() > 0 ? (MallGroupVO)lst.get(0) : null;
                        if (g != null) {
                            saleOutProduct = g.getGroupName();
                        }
                    }
                    if (c.getPromotions() != null) {
                        lst = c.getPromotions().stream().filter(c1 -> c1.getSoldOut() == true).collect(Collectors.toList());
                        Serializable serializable = p = lst.size() > 0 ? (MallPromotionVO)lst.get(0) : null;
                        if (p != null) {
                            saleOutProduct = ((MallPromotionEntity)((Object)p)).getPromotionName();
                        }
                    }
                    c.getDeliverVo().setBaseError(saleOutProduct + "\u5e93\u5b58\u4e0d\u8db3");
                }
                if (c.getDeliverVo().getInventory() == -1) {
                    c.getDeliverVo().setBaseError("\u6240\u5728\u57ce\u5e02\u57ce\u5e02\u5173\u95ed");
                }
                if (c.getDeliverVo().getInventory() == -2) {
                    c.getDeliverVo().setBaseError("\u6ca1\u6709\u9009\u62e9\u914d\u9001\u5730\u5740");
                }
                if (c.getDeliverVo().isBaseSuccess()) {
                    if (c.getDeliverVo().getDeliverDate() == null) {
                        c.getDeliverVo().setBaseError("\u63d0\u8d27\u65e5\u671f\u4e0d\u53ef\u914d\u9001");
                    } else if (deliverDate.compareTo(DateUtils.getDateFromString((String)c.getDeliverVo().getDeliverDate(), (String)"yyyy-MM-dd")) != 0) {
                        c.getDeliverVo().setBaseError("\u914d\u9001\u65e5\u671f\u4e0d\u5728\u914d\u9001\u8303\u56f4\uff1a" + c.getDeliverVo().getDeliverDate() + "|" + DateUtils.formatDate((Date)deliverDate, (String)"yyyy-MM-dd"));
                    }
                }
                if (c.getDeliverVo().isBaseSuccess()) {
                    if (c.getDeliverVo().getPickDate() != null) {
                        if (DateUtils.dateTimeCompare((Date)DateUtils.getDateFromString((String)c.getDeliverVo().getPickDate(), (String)"yyyy-MM-dd"), (Date)DateUtils.currentDate()) > 0L) {
                            c.getDeliverVo().setBaseError("\u63d0\u8d27\u65e5\u671f\uff08" + c.getDeliverVo().getPickDate() + "\uff09\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f");
                        }
                    } else {
                        c.getDeliverVo().setBaseError("\u914d\u9001\u65e5\u671f\u4e0d\u53ef\u914d\u9001");
                    }
                }
            }
            if (c.getDeliverVo() != null && !c.getDeliverVo().isBaseSuccess()) {
                err[0] = c.getDeliverVo().getBaseErrMsg();
            }
            ++loopCount;
        }
        if (mallMainOrderVo.getMallOrderVos().size() > 1 && mallMainOrderVo.getMallOrderVos().get(1).getDeliverVo() != null) {
            int inventoryOne = mallMainOrderVo.getMallOrderVos().get(0).getDeliverVo().getInventory();
            int inventoryTwo = mallMainOrderVo.getMallOrderVos().get(1).getDeliverVo().getInventory();
            int inventoryInt = inventoryOne;
            if (inventoryOne == -1 || inventoryTwo == -1) {
                inventoryInt = -1;
            }
            if (inventoryOne == 0 || inventoryTwo == 0) {
                inventoryInt = 0;
            }
            mallMainOrderVo.getMallOrderVos().get(0).getDeliverVo().setInventory(inventoryInt);
            mallMainOrderVo.getMallOrderVos().get(1).getDeliverVo().setInventory(inventoryInt);
        }
        if ((time = (endTime = System.currentTimeMillis()) - startTime) > 1000L) {
            logger.info("*************************cc.lechun.mall.service.trade.orderHandle.orderHandle.Time*************************time={}", (Object)time);
        }
        if (err[0].isEmpty()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)err[0]);
    }
}

