/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.constants.message.WechatMsgType;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinKeywordMapper;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordVo;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import com.github.pagehelper.PageHelper;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.MediaAPI;
import weixin.popular.bean.media.Media;
import weixin.popular.bean.media.MediaType;
import weixin.popular.bean.message.message.ImageMessage;
import weixin.popular.bean.message.message.NewsMessage;
import weixin.popular.bean.message.message.TextMessage;

@Service
public class WeiXinKeywordService
extends BaseService
implements WeiXinKeywordInterface {
    @Autowired
    private WeiXinKeywordMapper weiXinKeywordMapper;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private OssService ossService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private WeiXinMediaInterface mediaInterface;

    @Override
    public BaseJsonVo saveKeyword(WeiXinKeywordEntity weiXinKeywordEntity) {
        if ("image".equals(weiXinKeywordEntity.getType())) {
            String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(weiXinKeywordEntity.getPlatformId()).getAccessToken();
            if (StringUtils.isNotEmpty((String)accessToken)) {
                try {
                    Media media = MediaAPI.mediaUpload((String)accessToken, (MediaType)MediaType.image, (URI)new URI(this.ossService.getImageResoure(weiXinKeywordEntity.getImageUrl())));
                    if (media == null) {
                        return BaseJsonVo.error((String)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
                    }
                    weiXinKeywordEntity.setMediaId(media.getMedia_id());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    return BaseJsonVo.error((String)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
                }
            } else {
                this.logger.error("accesstoken\u4e0d\u5b58\u5728," + weiXinKeywordEntity.toString());
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
            }
        }
        this.removeCache(weiXinKeywordEntity.getType(), weiXinKeywordEntity.getKeyword(), weiXinKeywordEntity.getId(), weiXinKeywordEntity.getPlatformId());
        WeiXinKeywordEntity keywordEntitySearch = new WeiXinKeywordEntity();
        keywordEntitySearch.setKeyword(weiXinKeywordEntity.getKeyword());
        keywordEntitySearch = (WeiXinKeywordEntity)this.weiXinKeywordMapper.getSingle(keywordEntitySearch);
        boolean b = false;
        if (weiXinKeywordEntity.getId() == null || weiXinKeywordEntity.getId() == 0) {
            weiXinKeywordEntity.setCreateTime(DateUtils.now());
            if (keywordEntitySearch != null) {
                return BaseJsonVo.error((String)"\u5173\u952e\u5b57\u5df2\u5b58\u5728");
            }
            b = this.weiXinKeywordMapper.insertSelective(weiXinKeywordEntity) >= 1;
        } else {
            if (keywordEntitySearch != null && !keywordEntitySearch.getId().equals(weiXinKeywordEntity.getId())) {
                return BaseJsonVo.error((String)"\u5173\u952e\u5b57\u5df2\u5b58\u5728");
            }
            boolean bl = b = this.weiXinKeywordMapper.updateByPrimaryKeySelective(weiXinKeywordEntity) >= 1;
        }
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinKeywordService.getWeiXinKeywordById")
    public WeiXinKeywordEntity getWeiXinKeywordById(@ParameterValueKeyProvider int id) {
        return (WeiXinKeywordEntity)this.weiXinKeywordMapper.selectByPrimaryKey(Integer.valueOf(id));
    }

    @ReadThroughSingleCache(namespace="WeiXinKeywordService.getWeiXinKeywordContentById")
    public String getWeiXinKeywordContentById(@ParameterValueKeyProvider int id) {
        WeiXinKeywordEntity weiXinKeywordEntity = this.getWeiXinKeywordById(id);
        if (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getUrl())) {
            return MessageFormat.format("{0}<a href='{1}'>{2}</a>", weiXinKeywordEntity.getTitle(), weiXinKeywordEntity.getUrl(), weiXinKeywordEntity.getContent());
        }
        return MessageFormat.format("{0}{1}", weiXinKeywordEntity.getTitle(), weiXinKeywordEntity.getContent());
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinKeywordService.getKeywordListByStatus", expiration=300)
    public List<WeiXinKeywordEntity> getKeywordListByStatus(@ParameterValueKeyProvider(order=0) Integer status, @ParameterValueKeyProvider(order=1) Integer platformId) {
        return this.weiXinKeywordMapper.getKeywordListByStatus(status, platformId);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinKeywordService.getKeywordByKeyword")
    public WeiXinKeywordEntity getKeywordByKeyword(@ParameterValueKeyProvider(order=0) String keyword, @ParameterValueKeyProvider(order=1) Integer platformId) {
        return this.weiXinKeywordMapper.getKeywordByKeyword(keyword, platformId);
    }

    @Override
    public boolean deleteKeyword(int id) {
        WeiXinKeywordEntity weiXinKeywordEntity = this.getWeiXinKeywordById(id);
        this.removeCache(weiXinKeywordEntity.getType(), weiXinKeywordEntity.getKeyword(), weiXinKeywordEntity.getId(), weiXinKeywordEntity.getPlatformId());
        return this.weiXinKeywordMapper.deleteByPrimaryKey(Integer.valueOf(id)) >= 1;
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinKeywordService.getEnableKeywordList", expiration=300)
    public List<WeiXinKeywordEntity> getEnableKeywordList(@ParameterValueKeyProvider Integer platformId) {
        return this.weiXinKeywordMapper.getEnableKeywordList(platformId);
    }

    @Override
    public List<WeiXinKeywordVo> getKeywordList4Media(int pageNum, int pageSize, WeiXinKeywordEntity keywordEntity) {
        return PageHelper.startPage((int)pageNum, (int)pageSize).doSelectPage(() -> this.weiXinKeywordMapper.getKeywordList4Media(keywordEntity));
    }

    @Override
    public String getContent(WeiXinKeywordEntity keywordEntity, String para1, String para2, String para3) {
        String content = "";
        String string = content = StringUtils.isNotEmpty((String)keywordEntity.getTitle()) ? MessageFormat.format(keywordEntity.getTitle(), para1, para2, para3) : "";
        content = StringUtils.isNotEmpty((String)keywordEntity.getUrl()) ? content + "<a href='" + keywordEntity.getUrl() + "'>" + (StringUtils.isNotEmpty((String)keywordEntity.getContent()) ? keywordEntity.getContent() : "") + "</a>" : content + (StringUtils.isNotEmpty((String)keywordEntity.getContent()) ? keywordEntity.getContent() : "");
        return content;
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinKeywordService.getKeywordMapContent")
    public Map<String, String> getKeywordMapContent(@ParameterValueKeyProvider Integer keywordId) {
        WeiXinKeywordEntity keywordEntity = this.getWeiXinKeywordById(keywordId);
        return this.getKeywordMapContent(keywordEntity);
    }

    @Override
    public String replaceVariable(String src, Map<String, String> variable) {
        boolean i = false;
        if (variable == null || variable.size() == 0) {
            return src;
        }
        for (String k : variable.keySet()) {
            src = src.replace("${" + k + "}", variable.get(k));
            src = src.replace("$" + k, variable.get(k));
            src = src.replace("{" + k + "}", variable.get(k));
        }
        return src;
    }

    @Override
    public BaseJsonVo getKeywordContent(Integer keywordId, Map<String, String> variable) {
        WeiXinKeywordEntity keywordEntity = this.getWeiXinKeywordById(keywordId);
        return this.getKeywordContent(keywordEntity, variable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo getKeywordContent(WeiXinKeywordEntity keywordEntity, Map<String, String> variable) {
        Map<String, String> map1 = this.getKeywordMapContent(keywordEntity);
        if (map1.size() == 0) {
            return BaseJsonVo.error((String)"\u5173\u952e\u5b57\u6ca1\u6709\u8bbe\u7f6e\u5185\u5bb9");
        }
        TextMessage message = null;
        if (map1.containsKey(WechatMsgType.text)) {
            message = new TextMessage("", this.replaceVariable(map1.get(WechatMsgType.text), variable));
        } else if (map1.containsKey(WechatMsgType.news)) {
            List<WeiXinMediaEntity> mediaEntities = this.mediaInterface.getMediaListByMediaId(map1.get(WechatMsgType.news));
            ArrayList<NewsMessage.Article> articles = new ArrayList<NewsMessage.Article>();
            if (mediaEntities == null || mediaEntities.size() <= 0) return BaseJsonVo.error((String)"\u7d20\u6750\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5173\u952e\u5b57\u6ca1\u6709\u5173\u8054\u7d20\u6750");
            for (WeiXinMediaEntity mediaEntity : mediaEntities) {
                NewsMessage.Article article = new NewsMessage.Article(mediaEntity.getTitle(), mediaEntity.getDigest(), mediaEntity.getUrl(), mediaEntity.getImageUrl());
                articles.add(article);
            }
            message = new NewsMessage("", articles);
        } else {
            if (!map1.containsKey(WechatMsgType.image)) return BaseJsonVo.error((String)"\u6682\u4e0d\u652f\u6301\u8be5\u6d88\u606f\u7c7b\u578b\u7684\u53d1\u9001");
            message = new ImageMessage("", map1.get(WechatMsgType.image));
        }
        if (message != null) return BaseJsonVo.success((Object)message);
        return BaseJsonVo.error((String)"\u6682\u4e0d\u652f\u6301\u8be5\u6d88\u606f\u7c7b\u578b\u7684\u53d1\u9001");
    }

    @Override
    public Map<String, String> getKeywordMapContent(WeiXinKeywordEntity keywordEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (keywordEntity != null) {
            if (keywordEntity.getType().equals(WechatMsgType.text)) {
                String outContent = keywordEntity.getTitle();
                if (keywordEntity.getUrl() != null && !keywordEntity.getUrl().isEmpty()) {
                    outContent = outContent + "<a href='" + keywordEntity.getUrl() + "'>" + keywordEntity.getContent() + "</a>";
                } else if (StringUtils.isNotEmpty((String)keywordEntity.getContent())) {
                    outContent = outContent + keywordEntity.getContent();
                }
                map.put(keywordEntity.getType(), outContent);
            } else if (keywordEntity.getType().equals(WechatMsgType.news)) {
                map.put(keywordEntity.getType(), keywordEntity.getMediaId());
            } else if (keywordEntity.getType().equals(WechatMsgType.image)) {
                map.put(keywordEntity.getType(), keywordEntity.getMediaId());
            }
        }
        return map;
    }

    private void removeCache(String type, String keyword, int id, int platformId) {
        this.memcachedService.delete("WeiXinKeywordService.getEnableKeywordList", String.valueOf(platformId));
        this.memcachedService.delete("WeiXinKeywordService.getKeywordByKeyword", keyword);
        this.memcachedService.delete("WeiXinKeywordService.getWeiXinKeywordContentById", String.valueOf(id));
        this.memcachedService.delete("WeiXinKeywordService.getKeywordListByStatus", new String[]{"0", String.valueOf(platformId)});
        this.memcachedService.delete("WeiXinKeywordService.getKeywordListByStatus", new String[]{"1", String.valueOf(platformId)});
        this.memcachedService.delete("WeiXinKeywordService.getKeywordListByStatus", new String[]{null, String.valueOf(platformId)});
        this.memcachedService.delete("WeiXinKeywordService.getWeiXinKeywordById", String.valueOf(id));
        this.memcachedService.delete("WeiXinKeywordService.getKeywordMapContent", String.valueOf(id));
        this.memcachedService.delete("WeiXinKeywordService.getKeywordContent", String.valueOf(id));
    }
}

