/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.domain;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.organization.dao.VoteMapper;
import cc.lechun.organization.entity.VoteEntity;
import cc.lechun.organization.idomain.IOrgVoteDomain;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgVoteDomain
extends BaseService
implements IOrgVoteDomain {
    @Autowired
    private VoteMapper voteMapper;

    @Override
    public VoteEntity getVoteEntity(VoteEntity voteEntity) {
        return (VoteEntity)this.voteMapper.getSingle(voteEntity);
    }

    @Override
    public List<VoteEntity> getVoteList(VoteEntity voteEntity) {
        return this.voteMapper.getList(voteEntity);
    }

    @Override
    public List<Map<String, Object>> getRankingList(Integer periodId, Integer questionClassId, String userId) {
        return this.voteMapper.getRankingList(periodId, questionClassId, userId);
    }

    @Override
    public List<Map<String, Object>> getAcceptGratefulList(Integer periodId, Integer questionType) {
        return this.voteMapper.getAcceptGratefulList(periodId, questionType);
    }

    @Override
    public List<Map<String, Object>> getGratefulList(Integer periodId, Integer questionType) {
        return this.voteMapper.getGratefulList(periodId, questionType);
    }

    @Override
    public Integer getVoteStatus(String userId, String paperId) {
        VoteEntity voteEntity = new VoteEntity();
        voteEntity.setPaperId(paperId);
        voteEntity.setUserId(userId);
        VoteEntity resultVoteEntity = (VoteEntity)this.voteMapper.getSingle(voteEntity);
        if (resultVoteEntity != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public BaseJsonVo saveVote(VoteEntity voteEntity) {
        BaseJsonVo baseJsonVo;
        VoteEntity queryVote = new VoteEntity();
        queryVote.setPaperId(voteEntity.getPaperId());
        queryVote.setVoteUserId(voteEntity.getVoteUserId());
        if (this.voteMapper.existsByEntity(queryVote) > 0 && (baseJsonVo = this.removeVote(voteEntity.getVoteUserId(), voteEntity.getPaperId())).isSuccess()) {
            voteEntity.setCreateTime(DateUtils.now());
            return this.voteMapper.insertSelective(voteEntity) > 0 ? BaseJsonVo.success((Object)"\u70b9\u8d5e\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        voteEntity.setCreateTime(DateUtils.now());
        return this.voteMapper.insertSelective(voteEntity) > 0 ? BaseJsonVo.success((Object)"\u70b9\u8d5e\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo removeVote(String userId, String paperId) {
        VoteEntity voteEntity = new VoteEntity();
        voteEntity.setPaperId(paperId);
        voteEntity.setVoteUserId(userId);
        VoteEntity resultVoteEntity = (VoteEntity)this.voteMapper.getSingle(voteEntity);
        if (resultVoteEntity != null) {
            return this.voteMapper.deleteByPrimaryKey(resultVoteEntity.getId()) > 0 ? BaseJsonVo.success((Object)"\u70b9\u8d5e\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return BaseJsonVo.error((String)"\u70b9\u8d5e\u8bb0\u5f55\u4e0d\u5b58\u5728");
    }
}

