/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerRelationEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerRelationDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgPaperAnswerRelationService
extends BaseService
implements IOrgPaperAnswerRelationService {
    @Autowired
    private IOrgPaperAnswerRelationDomain relationDomain;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgQuestionDomain questionDomain;

    @Override
    public BaseJsonVo savePaperAnswerRelation(Integer questionType, PaperAnswerEntity answerEntity, List<PaperAnswerRelationEntity> relationEntityList) {
        this.relationDomain.delete(answerEntity.getId());
        for (PaperAnswerRelationEntity r : relationEntityList) {
            MallUserEntity userEntity;
            r.setAnswerId(answerEntity.getId());
            r.setQuestionId(answerEntity.getQuestionId());
            QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
            r.setQuestionName(questionEntity.getQuestionName());
            r.setCreateTime(new Date());
            r.setIsnew(1);
            if (r.getContent() != null) {
                r.setContent(r.getContent().replaceAll("[\\r]", "<br/>").replace("\n", "<br/>"));
            }
            if ((userEntity = this.userInterface.getMallUser(r.getRelationUserId())) != null) {
                r.setRelationUserName(userEntity.getUserNick());
            }
            this.relationDomain.insert(r);
        }
        return BaseJsonVo.success((Object)"");
    }
}

