/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PaperPageListVo;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.VoteEntity;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgVoteDomain;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgPaperService
extends BaseService
implements IOrgPaperService {
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgPermittedUsersService permittedUsersService;
    @Autowired
    private IOrgQuestionClassDomain classDomain;
    @Autowired
    private IOrgPaperService paperService;
    @Autowired
    private IOrgVoteDomain orgVoteService;

    @Override
    public BaseJsonVo savePaper(PaperEntity paperEntity) {
        boolean success = false;
        PaperEntity search = new PaperEntity();
        search.setPeriodId(paperEntity.getPeriodId());
        search.setUserId(paperEntity.getUserId());
        search.setQuestionClassId(paperEntity.getQuestionClassId());
        PaperEntity paperExists = this.orgPaperDomain.getSingle(search);
        if (StringUtils.isEmpty((String)paperEntity.getId())) {
            paperEntity.setId(IDGenerate.getUniqueIdStr());
        }
        if (paperExists == null) {
            success = this.orgPaperDomain.insert(paperEntity);
        }
        return success ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo buildPaper() {
        List<QuestionClassEntity> classEntities = this.classDomain.getQuestionClassEntityList(0);
        for (QuestionClassEntity c : classEntities) {
            if (c.getRoleId() == null) continue;
            List<MallUserEntity> userEntities = this.userInterface.getSysUserList4RoleId(c.getRoleId());
            for (MallUserEntity u : userEntities) {
                this.paperService.buildPaper(u.getUserId(), c.getClassId());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo buildPaper(String userId, Integer classId) {
        BaseJsonVo<PeriodEntity> periodEntity = this.periodService.currentPeriod();
        if (periodEntity.getValue() == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)userId) || classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(IDGenerate.getUniqueIdStr());
        paperEntity.setQuestionClassId(classId);
        paperEntity.setPeriodId(((PeriodEntity)periodEntity.getValue()).getId());
        paperEntity.setPeriodName(((PeriodEntity)periodEntity.getValue()).getPeriodDesc());
        paperEntity.setUserId(userId);
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        if (userEntity != null) {
            paperEntity.setUserName(userEntity.getUserNick());
        }
        paperEntity.setCreateTime(new Date());
        paperEntity.setStatus(0);
        return this.savePaper(paperEntity);
    }

    @Override
    public BaseJsonVo getPaperPageList(PageForm pageForm, PaperEntity paperEntity, String userId) {
        this.buildPaper(userId, paperEntity.getQuestionClassId());
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        users.add(userId);
        PageInfo pageInfo = this.orgPaperDomain.getPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), paperEntity, users, userId);
        pageInfo.getList().forEach(c -> this.getStatus(paperEntity, userId, (PaperPageListVo)c));
        return BaseJsonVo.success((Object)pageInfo);
    }

    private boolean isEdit(PaperEntity paperEntity, String userId) {
        return this.periodService.isInPeriodWithDelay(paperEntity.getPeriodId()).isSuccess() && userId.equals(paperEntity.getUserId());
    }

    private boolean isVote(PaperEntity paperEntity, String userId) {
        return !userId.equals(paperEntity.getUserId());
    }

    private void getStatus(PaperEntity paperEntity, String userId, PaperPageListVo c) {
        if (c.getStatus() == null || c.getStatus() == 0) {
            c.setStatus(0);
            c.setStatusName("\u672a\u586b\u5199");
            c.setIsVote(1);
            c.setCommit("");
            c.setVoteNum(0);
        }
        c.setIsEdit(this.isEdit(c, userId) ? 1 : 0);
        if (!userId.equals(paperEntity.getUserId())) {
            if (c.getStatus() == 1) {
                c.setStatusName("\u5df2\u586b\u5199");
                VoteEntity queryVote = new VoteEntity();
                queryVote.setVoteUserId(userId);
                queryVote.setPeriodId(paperEntity.getPeriodId());
                queryVote.setQuestionClassId(paperEntity.getQuestionClassId());
                queryVote.setUserId(c.getUserId());
                this.logger.info("\u6295\u7968\u67e5\u8be2\u53c2\u6570:{}", (Object)queryVote.toString());
                VoteEntity voteEntity = this.orgVoteService.getVoteEntity(queryVote);
                if (voteEntity != null) {
                    c.setIsVote(2);
                    c.setVoteNum(1);
                    c.setCommit(StringUtils.isNotEmpty((String)voteEntity.getCommit()) ? voteEntity.getCommit() : "\u672a\u8bc4\u8bba");
                } else {
                    c.setIsVote(1);
                    c.setCommit("");
                    c.setVoteNum(0);
                }
            } else {
                c.setIsVote(0);
            }
        } else {
            c.setIsVote(0);
        }
    }
}

