/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallResourceEntity;
import cc.lechun.mall.iservice.user.SysResourceInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.dao.AssociateUsersMapper;
import cc.lechun.organization.entity.AssociateUsersEntity;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class OrgPermittedUsersService
extends BaseService
implements IOrgPermittedUsersService {
    @Autowired
    AssociateUsersMapper associateUsersMapper;
    @Autowired
    SysUserInterface userInterface;
    @Autowired
    SysResourceInterface resourceInterface;

    @Override
    public Set<String> findAllPermittedUsers(String userId, Integer classId) {
        AssociateUsersEntity param = new AssociateUsersEntity();
        param.setUserId(userId);
        param.setClassId(classId);
        List users = this.associateUsersMapper.getList(param);
        Set<String> subordinates = this.userInterface.getSubordinate(userId);
        for (AssociateUsersEntity user : users) {
            subordinates.add(user.getAssociateUserId());
        }
        return subordinates;
    }

    @Override
    public Set<String> findAllPermittedUsersFromResource(String userId, Integer resourceId) {
        HashSet<String> total = new HashSet<String>();
        total.addAll(this.resourceInterface.findAssociateGroupUsers(userId, resourceId));
        total.addAll(this.userInterface.getSubordinate(userId));
        return total;
    }

    @Override
    public Set<String> findAllPermittedUsersFromResource(String userId, String resourcePath) {
        MallResourceEntity entity = this.resourceInterface.getResourceWithPath(resourcePath);
        if (entity != null) {
            return this.findAllPermittedUsersFromResource(userId, entity.getResourceId());
        }
        return new HashSet<String>();
    }

    @Override
    public Set<String> findAllPermittedUsersFromResource(String userId) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String resourcePath = request.getParameter("pageRouterUrl");
        this.logger.info(">>>>>>>>>>>>>>>" + resourcePath);
        if (StringUtils.isEmpty((String)resourcePath)) {
            resourcePath = request.getHeader("webUrl");
        }
        this.logger.info(")))))))))))))))" + resourcePath);
        return this.findAllPermittedUsersFromResource(userId, resourcePath);
    }

    @Override
    public void importData(Integer classId, String[] userIds) {
        for (int i = 0; i < userIds.length; ++i) {
            for (int j = 0; j < userIds.length; ++j) {
                if (i == j) continue;
                AssociateUsersEntity entity = new AssociateUsersEntity();
                entity.setUserId(userIds[i]);
                entity.setClassId(classId);
                entity.setAssociateUserId(userIds[j]);
                try {
                    this.associateUsersMapper.insert(entity);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("\u4fdd\u5b58\u5931\u8d25[" + JsonUtils.toJson((Object)entity, (boolean)false) + "]", (Throwable)e);
                }
            }
        }
    }
}

