/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.domain.OrgQuestionClassDomain;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.VoteEntity;
import cc.lechun.organization.entity.VoteQueryVo;
import cc.lechun.organization.entity.VoteRankItem;
import cc.lechun.organization.entity.VoteRankVo;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgVoteDomain;
import cc.lechun.organization.iservice.IOrgQuestionClassService;
import cc.lechun.organization.iservice.IOrgVoteOperateService;
import cc.lechun.organization.iservice.IPeriodService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgVoteOperateService
extends BaseService
implements IOrgVoteOperateService {
    @Autowired
    private IOrgVoteDomain orgVoteService;
    @Autowired
    private IOrgPaperDomain orgPaperService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private OrgQuestionClassDomain questionClassService;
    @Autowired
    private SysUserInterface sysUserInterface;
    @Autowired
    private IOrgVoteOperateService orgVoteOperateService;
    @Autowired
    private IOrgQuestionClassService orgQuestionClassService;
    @Autowired
    private IPeriodService periodService;

    @Override
    public VoteEntity getVoteEntity(VoteEntity voteEntity) {
        return this.orgVoteService.getVoteEntity(voteEntity);
    }

    @Override
    public BaseJsonVo getVoteList(PageForm pageForm, VoteEntity voteEntity) {
        this.logger.info("\u67e5\u8be2\u70b9\u8d5e\u53c2\u6570:{}", (Object)voteEntity.toString());
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("ID desc");
        this.orgVoteService.getVoteList(voteEntity);
        PageInfo pageInfo = page.toPageInfo();
        PageInfo pg2 = new PageInfo();
        ArrayList list = new ArrayList();
        if (pageInfo != null && pageInfo.getList() != null && pageInfo.getList().size() > 0) {
            pageInfo.getList().forEach(v -> {
                VoteQueryVo voteQueryVo = new VoteQueryVo();
                BeanUtils.copyProperties((Object)v, (Object)voteQueryVo);
                MallUserEntity mallUserEntity = this.sysUserInterface.getMallUser(v.getVoteUserId());
                voteQueryVo.setVoteUserName(mallUserEntity != null ? mallUserEntity.getUserNick() : "");
                voteQueryVo.setPeriodDesc("");
                list.add(voteQueryVo);
                PeriodEntity periodEntity = this.periodService.getPeriodEntity(v.getPeriodId());
                voteQueryVo.setPeriodDesc(periodEntity == null ? "" : periodEntity.getPeriodDesc());
            });
        }
        pg2.setList(list);
        pg2.setTotal(page.getTotal());
        return BaseJsonVo.success((Object)pg2);
    }

    @Override
    public VoteRankVo getRankingList(PeriodEntity periodEntity, Integer questionClassId) {
        VoteRankVo voteRankDo = new VoteRankVo();
        this.logger.info("\u67e5\u8be2\u6392\u884c\u699c\u8bb0\u5f55\u67e5\u8be2\u53c2\u6570:{},{}", (Object)periodEntity.toString(), (Object)questionClassId);
        QuestionClassEntity questionClassEntity = this.questionClassService.getQuestionClassEntity(questionClassId);
        List<Object> rankingList = new ArrayList();
        voteRankDo.setPeriodName(StringUtils.isNotEmpty((String)periodEntity.getPeriodDesc()) ? periodEntity.getPeriodDesc() : "\u603b\u699c");
        voteRankDo.setReriodType(periodEntity.getId() == null ? 2 : 1);
        if (questionClassId < 3) {
            rankingList = this.orgVoteService.getRankingList(periodEntity.getId(), questionClassId, "");
            voteRankDo.setQuestionClassName(questionClassEntity == null ? "" : questionClassEntity.getClassName());
        } else {
            if (questionClassId == 4) {
                rankingList = this.orgVoteService.getAcceptGratefulList(periodEntity.getId(), 5);
                voteRankDo.setQuestionClassName("\u6536\u5230\u611f\u8c22\u699c");
            }
            if (questionClassId == 5) {
                rankingList = this.orgVoteService.getGratefulList(periodEntity.getId(), 5);
                voteRankDo.setQuestionClassName("\u61c2\u5f97\u611f\u6069\u699c");
            }
        }
        this.logger.info("\u67e5\u8be2\u6392\u884c\u699c\u8bb0\u5f55,\u671f\u6b21{}:\u6295\u7968\u6570:{}", (Object)periodEntity.getId(), (Object)rankingList.size());
        ArrayList<VoteRankItem> list = new ArrayList<VoteRankItem>();
        if (rankingList != null && rankingList.size() > 0) {
            rankingList.forEach(v -> {
                this.logger.info("\u5df2\u70b9\u8d5e\u7528\u6237:{}", (Object)v.toString());
                VoteRankItem voteRankItem = new VoteRankItem();
                Integer voteNum = Integer.valueOf(v.get("num").toString());
                this.logger.info("\u5df2\u70b9\u8d5e\u7528\u6237:{},\u7968\u6570:{}", (Object)v.toString(), (Object)voteNum);
                if (v.get("USER_ID") != null) {
                    MallUserEntity mallUserEntity = this.sysUserInterface.getMallUser(v.get("USER_ID").toString());
                    voteRankItem.setUserName(mallUserEntity == null ? "\u00d7\u00d7\u00d7" : mallUserEntity.getUserNick());
                } else {
                    voteRankItem.setUserName("\u00d7\u00d7\u00d7");
                }
                voteRankItem.setVoteNum(String.valueOf(voteNum));
                list.add(voteRankItem);
            });
        }
        list.sort((v1, v2) -> v1.compareTo((VoteRankItem)v2));
        voteRankDo.setList(list);
        return voteRankDo;
    }

    @Override
    public BaseJsonVo<List<VoteRankVo>> getRankingList(Integer questionClassId) {
        VoteRankVo voteRankDo;
        PeriodEntity periodEntity;
        ArrayList<VoteRankVo> list = new ArrayList<VoteRankVo>();
        this.logger.info("\u53c2\u6570:questionClassId={}", (Object)questionClassId);
        if (questionClassId == 3) {
            return this.getRankingListByGratefulVoteRankVo(questionClassId);
        }
        BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod();
        if (baseJsonVo.isSuccess()) {
            periodEntity = (PeriodEntity)baseJsonVo.getValue();
            this.logger.info("\u53c2\u6570:{}", (Object)(periodEntity == null ? "" : periodEntity.toString()));
            voteRankDo = this.orgVoteOperateService.getRankingList(periodEntity, questionClassId);
            list.add(voteRankDo);
        }
        periodEntity = new PeriodEntity();
        voteRankDo = this.orgVoteOperateService.getRankingList(periodEntity, questionClassId);
        list.add(voteRankDo);
        return BaseJsonVo.success(list);
    }

    @Override
    public BaseJsonVo<List<VoteRankVo>> getRankingListByGratefulVoteRankVo(Integer questionClassId) {
        VoteRankVo voteRankVo2;
        VoteRankVo voteRankVo;
        PeriodEntity periodEntity;
        ArrayList<VoteRankVo> list = new ArrayList<VoteRankVo>();
        this.logger.info("\u53c2\u6570:questionClassId={}", (Object)questionClassId);
        BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getLastPeriod();
        if (baseJsonVo.isSuccess()) {
            periodEntity = (PeriodEntity)baseJsonVo.getValue();
            this.logger.info("\u53c2\u6570:{}", (Object)(periodEntity == null ? "" : periodEntity.toString()));
            voteRankVo = this.orgVoteOperateService.getRankingList(periodEntity, 4);
            list.add(voteRankVo);
            voteRankVo2 = this.orgVoteOperateService.getRankingList(periodEntity, 5);
            list.add(voteRankVo2);
        }
        periodEntity = new PeriodEntity();
        voteRankVo = this.orgVoteOperateService.getRankingList(periodEntity, 4);
        list.add(voteRankVo);
        voteRankVo2 = this.orgVoteOperateService.getRankingList(periodEntity, 5);
        list.add(voteRankVo2);
        return BaseJsonVo.success(list);
    }

    @Override
    public Integer getVoteStatus(String userId, String paperId) {
        return this.orgVoteService.getVoteStatus(userId, paperId);
    }

    @Override
    public BaseJsonVo saveVote(String userId, String paperId, String commit) {
        this.logger.info("\u70b9\u8d5e\u53c2\u6570:{},{},{}", new Object[]{userId, paperId, commit});
        PaperEntity paperEntity = this.orgPaperService.select(paperId);
        this.logger.info("\u70b9\u8d5e\u53c2\u6570:{}", (Object)paperEntity.getPeriodId());
        if (userId.equals(paperEntity.getUserId())) {
            return BaseJsonVo.error((String)"\u4e0d\u80fd\u7ed9\u81ea\u5df1\u70b9\u8d5e!");
        }
        VoteEntity voteEntity = new VoteEntity();
        voteEntity.setPaperId(paperId);
        voteEntity.setUserId(paperEntity.getUserId());
        voteEntity.setVoteUserId(userId);
        voteEntity.setPeriodId(paperEntity.getPeriodId());
        voteEntity.setQuestionClassId(paperEntity.getQuestionClassId());
        voteEntity.setCommit(commit);
        return this.orgVoteService.saveVote(voteEntity);
    }

    private int bs(int a, int b) {
        return (int)(new BigDecimal((float)a / (float)b).setScale(2, 4).doubleValue() * 100.0);
    }
}

