/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.common;

import cc.lechun.common.log.LogResultVo;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LogAopFilter {
    private static final Logger log_access = LoggerFactory.getLogger((String)"accessmonitor");
    private static final Logger log_aop = LoggerFactory.getLogger(LogAopFilter.class);

    @Around(value="execution(public * cc.lechun.*.service..*.*(..))")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        long time = System.currentTimeMillis();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        Object retVal = pjp.proceed();
        try {
            if (log_access.isInfoEnabled()) {
                log_access.info(JSON.toJSONString((Object)new LogResultVo(pjp.getTarget().getClass().getName(), method.getName(), System.currentTimeMillis() - time, (Object)pjp.getArgs(), retVal)));
            }
        }
        catch (Exception e) {
            log_aop.error("", (Throwable)e);
        }
        return retVal;
    }

    @AfterThrowing(value="execution(public * cc.lechun.*.service..*.*(..))", throwing="ex")
    public void doThrowing(JoinPoint jp, Throwable ex) {
        log_aop.error(JSON.toJSONString((Object)jp.getArgs(), (boolean)true), ex);
    }
}

