/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.common;

import cc.lechun.utils.web.IpUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SecurityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SecurityFilter.class);
    private List<String> ipWhiteList = new ArrayList<String>();
    @Value(value="${ipWhite}")
    private String ipWhite;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.ipWhiteList = Arrays.asList(this.ipWhite.split(","));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        if (this.ipWhiteList.contains(ip)) {
            if (log.isDebugEnabled()) {
                log.debug("\u8bf7\u6c42IP" + ip);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            log.error("\u4e0d\u5728IP\u767d\u540d\u5355" + ip);
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.sendRedirect("http://www.lechun.cc");
        }
    }

    public void destroy() {
    }
}

