/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.database.aop;

import cc.lechun.core.database.config.dbconfig.DataSourceContextHolder;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
@Component
public class DataSourceAopInDao {
    private static Logger log = LoggerFactory.getLogger(DataSourceAopInDao.class);

    @Before(value="(execution(* cc.lechun.core.baseclass.BaseDao..*.find*(..))  or execution(* cc.lechun.core.baseclass.BaseDao..*.get*(..))  or execution(* cc.lechun.core.baseclass.BaseDao..*.query*(..)) or execution(* cc.lechun.core.baseclass.BaseDao..*.select*(..)) or execution(* cc.lechun.core.baseclass.BaseDao..*.exists*(..)) or execution(* cc.lechun.*.dao..*.find*(..)) or execution(* cc.lechun.*.dao..*.get*(..)) or execution(* cc.lechun.*.dao..*.query*(..)) or execution(* cc.lechun.*.dao..*.select*(..))) or execution(* cc.lechun.*.dao..*.exists*(..)))")
    public void setReadDataSourceType() {
        try {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                DataSourceContextHolder.setWrite();
                return;
            }
        }
        catch (NoTransactionException e) {
            e.printStackTrace();
        }
    }

    @Before(value="execution(* cc.lechun.core.baseclass.BaseDao..*.insert*(..))  or execution(* cc.lechun.core.baseclass.BaseDao..*.delete*(..))  or execution(* cc.lechun.core.baseclass.BaseDao..*.update*(..)) or execution(* cc.lechun.core.baseclass.BaseDao..*.drop*(..)) or execution(* cc.lechun.core.baseclass.BaseDao..*.truncate*(..)) or execution(* cc.lechun.core.baseclass.BaseDao..*.alter*(..)) or execution(* cc.lechun.core.baseclass.BaseDao..*.create*(..)) or execution(* cc.lechun.*.dao..*.insert*(..)) or execution(* cc.lechun.*.dao..*.delete*(..)) or execution(* cc.lechun.*.dao..*.update*(..)) or execution(* cc.lechun.*.dao..*.drop*(..)) or execution(* cc.lechun.*.dao..*.truncate*(..)) or execution(* cc.lechun.*.dao..*.alter*(..)) or execution(* cc.lechun.*.dao..*.create*(..)) or execution(* cc.lechun.*.dao..*.save*(..))")
    public void setWriteDataSourceType() {
        DataSourceContextHolder.setWrite();
    }
}

