/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.database.config.dbconfig;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DataSourceConfiguration {
    private static Logger log = LoggerFactory.getLogger(DataSourceConfiguration.class);
    @Value(value="${mysql.datasource.type}")
    private Class<? extends DataSource> dataSourceType;

    @Bean(name={"writeDataSource"})
    @Primary
    @ConfigurationProperties(prefix="mysql.datasource.write")
    public DataSource writeDataSource() {
        log.info("-------------------- writeDataSource init ---------------------");
        return DataSourceBuilder.create().type(this.dataSourceType).build();
    }

    @Bean(name={"readDataSource01"})
    @ConfigurationProperties(prefix="mysql.datasource.read01")
    public DataSource readDataSourceOne() {
        log.info("-------------------- read01 DataSourceOne init ---------------------");
        return DataSourceBuilder.create().type(this.dataSourceType).build();
    }

    @Bean(name={"readDataSource02"})
    @ConfigurationProperties(prefix="mysql.datasource.read02")
    public DataSource readDataSourceTwo() {
        log.info("-------------------- read02 DataSourceTwo init ---------------------");
        return DataSourceBuilder.create().type(this.dataSourceType).build();
    }
}

