/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.database.config.dbconfig;

import cc.lechun.core.database.config.dbconfig.DataSourceConfiguration;
import cc.lechun.core.database.config.dbconfig.DataSourceContextHolder;
import cc.lechun.core.database.config.dbconfig.DataSourceType;
import cc.lechun.core.database.config.dbconfig.SqlPrintInterceptor;
import cc.lechun.core.database.util.SpringContextUtil;
import com.github.pagehelper.PageHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@AutoConfigureAfter(value={DataSourceConfiguration.class})
@MapperScan(basePackages={"cc.lechun.*.dao"})
public class MybatisConfiguration {
    private static Logger log = LoggerFactory.getLogger(MybatisConfiguration.class);
    @Value(value="${mysql.datasource.readSize}")
    private String readDataSourceSize;
    @Value(value="${mysql.datasource.mapperLocations}")
    private String mapperLocations;
    @Value(value="${mysql.datasource.configLocation}")
    private String configLocation;
    @Autowired
    @Qualifier(value="writeDataSource")
    private DataSource writeDataSource;
    @Autowired
    @Qualifier(value="readDataSource01")
    private DataSource readDataSource01;
    @Autowired
    @Qualifier(value="readDataSource02")
    private DataSource readDataSource02;

    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactorys() throws Exception {
        log.info("--------------------  sqlSessionFactory init ---------------------");
        try {
            SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
            sessionFactoryBean.setDataSource((DataSource)this.roundRobinDataSouceProxy());
            sessionFactoryBean.setTypeAliasesPackage("cc.lechun.core.database.domain");
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(this.mapperLocations);
            sessionFactoryBean.setMapperLocations(resources);
            sessionFactoryBean.setConfigLocation(new DefaultResourceLoader().getResource(this.configLocation));
            Interceptor[] plugins = new Interceptor[]{this.pageHelper(), new SqlPrintInterceptor()};
            sessionFactoryBean.setPlugins(plugins);
            log.info("--------------------  sqlSessionFactory init end ---------------------");
            SqlSessionFactory sq = sessionFactoryBean.getObject();
            log.info("--------------------  sqlSessionFactorys init end ---------------------");
            return sq;
        }
        catch (IOException e) {
            log.error("mybatis resolver mapper*xml is error", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error("mybatis sqlSessionFactoryBean create error", (Throwable)e);
            return null;
        }
    }

    @Bean
    public PageHelper pageHelper() {
        PageHelper pageHelper = new PageHelper();
        Properties p = new Properties();
        p.setProperty("offsetAsPageNum", "true");
        p.setProperty("rowBoundsWithCount", "true");
        p.setProperty("reasonable", "true");
        p.setProperty("returnPageInfo", "check");
        p.setProperty("params", "count=countSql");
        pageHelper.setProperties(p);
        return pageHelper;
    }

    @Bean(name={"roundRobinDataSouceProxy"})
    public AbstractRoutingDataSource roundRobinDataSouceProxy() {
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
        targetDataSources.put(DataSourceType.write.getType(), this.writeDataSource);
        targetDataSources.put(DataSourceType.read.getType() + "1", this.readDataSource01);
        targetDataSources.put(DataSourceType.read.getType() + "2", this.readDataSource02);
        final int readSize = Integer.parseInt(this.readDataSourceSize);
        AbstractRoutingDataSource proxy = new AbstractRoutingDataSource(){
            private AtomicInteger count = new AtomicInteger(0);

            protected Object determineCurrentLookupKey() {
                String typeKey = DataSourceContextHolder.getReadOrWrite();
                if (typeKey == null) {
                    return DataSourceType.write.getType();
                }
                if (typeKey.equals(DataSourceType.write.getType())) {
                    return DataSourceType.write.getType();
                }
                int number = this.count.getAndAdd(1);
                int lookupKey = number % readSize;
                return DataSourceType.read.getType() + (lookupKey + 1);
            }
        };
        proxy.setDefaultTargetDataSource((Object)this.writeDataSource);
        proxy.setTargetDataSources(targetDataSources);
        return proxy;
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager((DataSource)SpringContextUtil.getBean("roundRobinDataSouceProxy"));
    }
}

