/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.jms;

import cc.lechun.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.core.jms.AbstractMessageListener;
import cc.lechun.mall.iservice.jms.MessageQueueInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="baseMessageListener")
public class BaseMessageListener
extends AbstractMessageListener {
    private final Map<String, MessageQueueInterface> messageQueueInterfaceMap = new ConcurrentHashMap<String, MessageQueueInterface>();

    @Autowired
    public BaseMessageListener(Map<String, MessageQueueInterface> messageQueueInterfaceMap) {
        this.messageQueueInterfaceMap.clear();
        messageQueueInterfaceMap.forEach((k, v) -> this.messageQueueInterfaceMap.put((String)k, (MessageQueueInterface)v));
    }

    @Override
    public boolean receive(Message message, ConsumeContext context) {
        try {
            String name = MessageQueueTagEnum.getName((String)message.getTag());
            if (name.isEmpty()) {
                return false;
            }
            if (this.messageQueueInterfaceMap.get(message.getTag()) != null) {
                return this.messageQueueInterfaceMap.get(message.getTag()).receive(message, context);
            }
        }
        catch (Exception e) {
            this.log.error("\u57fa\u672c\u6d88\u606f\u5904\u7406\u5931\u8d25,\u6d88\u606ftag\uff1a" + message.getTag() + "," + message.getMsgID(), (Throwable)e);
        }
        return true;
    }
}

