/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.jms;

import cc.lechun.core.jms.AbstractOrderMessageListener;
import cc.lechun.core.jms.JmsOnsConfig;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JmsServiceConfig {
    @Autowired
    private JmsOnsConfig jmsOnsConfig;
    @Resource(name="baseMessageListener")
    private MessageListener baseMessageListener;
    @Resource(name="taskOrBigMessageListener")
    private MessageListener taskOrBigMessageListener;
    @Resource(name="orderMessageListener")
    private AbstractOrderMessageListener orderMessageListener;

    @Bean(initMethod="start", destroyMethod="shutdown")
    public Producer baseProducer() {
        Properties properties = new Properties();
        properties.put("ProducerId", this.jmsOnsConfig.getProducer_id());
        properties.put("AccessKey", this.jmsOnsConfig.getAccessKey());
        properties.put("SecretKey", this.jmsOnsConfig.getSecretKey());
        Producer producer = ONSFactory.createProducer((Properties)properties);
        return producer;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public Consumer baseConsumer() {
        Properties properties = new Properties();
        properties.put("AccessKey", this.jmsOnsConfig.getAccessKey());
        properties.put("SecretKey", this.jmsOnsConfig.getSecretKey());
        properties.put("ConsumerId", this.jmsOnsConfig.getConsumer_id());
        properties.put("maxReconsumeTimes", "5");
        Consumer consumer = ONSFactory.createConsumer((Properties)properties);
        consumer.subscribe(this.jmsOnsConfig.getTopic_base(), "*", this.baseMessageListener);
        return consumer;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public Producer taskOrBigProducer() {
        Properties properties = new Properties();
        properties.put("ConsumerId", this.jmsOnsConfig.getProducer_id_task_big());
        properties.put("AccessKey", this.jmsOnsConfig.getAccessKey());
        properties.put("SecretKey", this.jmsOnsConfig.getSecretKey());
        Producer producer = ONSFactory.createProducer((Properties)properties);
        return producer;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public Consumer taskOrBigConsumer() {
        Properties properties = new Properties();
        properties.put("AccessKey", this.jmsOnsConfig.getAccessKey());
        properties.put("SecretKey", this.jmsOnsConfig.getSecretKey());
        properties.put("ConsumerId", this.jmsOnsConfig.getConsumer_id_task_big());
        Consumer consumer = ONSFactory.createConsumer((Properties)properties);
        consumer.subscribe(this.jmsOnsConfig.getTopic_task_big(), "*", this.taskOrBigMessageListener);
        return consumer;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public OrderProducer orderProducer() {
        Properties properties = new Properties();
        properties.put("ProducerId", this.jmsOnsConfig.getProducer_id_order());
        properties.put("AccessKey", this.jmsOnsConfig.getAccessKey());
        properties.put("SecretKey", this.jmsOnsConfig.getSecretKey());
        OrderProducer producer = ONSFactory.createOrderProducer((Properties)properties);
        return producer;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public OrderConsumer orderConsumer() {
        Properties properties = new Properties();
        properties.put("AccessKey", this.jmsOnsConfig.getAccessKey());
        properties.put("SecretKey", this.jmsOnsConfig.getSecretKey());
        properties.put("ConsumerId", this.jmsOnsConfig.getConsumer_id_order());
        properties.put("suspendTimeMillis", "100");
        properties.put("maxReconsumeTimes", "20");
        OrderConsumer consumer = ONSFactory.createOrderedConsumer((Properties)properties);
        consumer.subscribe(this.jmsOnsConfig.getTopic_order(), "*", (MessageOrderListener)this.orderMessageListener);
        return consumer;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public Producer wechatMessageProducer() {
        Properties properties = new Properties();
        properties.put("ProducerId", this.jmsOnsConfig.getProducer_id_wechatMessage());
        properties.put("AccessKey", this.jmsOnsConfig.getAccessKey());
        properties.put("SecretKey", this.jmsOnsConfig.getSecretKey());
        Producer producer = ONSFactory.createProducer((Properties)properties);
        return producer;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public Consumer wechatMessageConsumer() {
        Properties properties = new Properties();
        properties.put("AccessKey", this.jmsOnsConfig.getAccessKey());
        properties.put("SecretKey", this.jmsOnsConfig.getSecretKey());
        properties.put("ConsumerId", this.jmsOnsConfig.getConsumer_id_wechatMessage());
        properties.put("maxReconsumeTimes", "5");
        Consumer consumer = ONSFactory.createConsumer((Properties)properties);
        consumer.subscribe(this.jmsOnsConfig.getTopic_wechatMessage(), "*", this.baseMessageListener);
        return consumer;
    }
}

