/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.jms;

import cc.lechun.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.common.vo.jms.MessageParam;
import cc.lechun.common.vo.jms.MessageResult;
import cc.lechun.core.jms.JmsOnsConfig;
import cc.lechun.utils.ids.RandomUtils;
import cc.lechun.utils.ids.Serializer;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageQueueService {
    private static final Logger log = LoggerFactory.getLogger(MessageQueueService.class);
    private static final Logger logOnsMessage = LoggerFactory.getLogger((String)"logOnsMessage");
    @Autowired
    private JmsOnsConfig jmsOnsConfig;
    @Autowired
    private Producer baseProducer;
    @Autowired
    private OrderProducer orderProducer;

    public MessageResult sendBaseMessage(MessageQueueTagEnum tag, MessageParam message) {
        boolean flg = false;
        SendResult sendResult = new SendResult();
        Message msg = new Message();
        try {
            msg.setTopic(this.jmsOnsConfig.getTopic_base());
            msg.setTag(tag.getValue());
            msg.setBody(Serializer.serialize((Object)message.getParams()));
            msg.setKey(RandomUtils.generateId() + ":" + (message.getKey() == null ? "" : message.getKey()));
            sendResult = this.baseProducer.send(msg);
            flg = true;
        }
        catch (Exception e) {
            log.error("\u666e\u901a\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
        MessageResult rs = new MessageResult(flg, sendResult, msg, "action", "SEND");
        logOnsMessage.info(JSON.toJSONString((Object)rs, (boolean)false));
        return rs;
    }

    public MessageResult sendTaskMessage(MessageQueueTagEnum tag, MessageParam message, long delaySecond) {
        boolean flg = false;
        SendResult sendResult = new SendResult();
        Message msg = new Message();
        try {
            msg.setTopic(this.jmsOnsConfig.getTopic_task_big());
            msg.setTag(tag.getValue());
            msg.setBody(Serializer.serialize((Object)message.getParams()));
            msg.setKey(RandomUtils.generateId() + ":" + (message.getKey() == null ? "" : message.getKey()));
            if (delaySecond > 0L) {
                msg.setStartDeliverTime(System.currentTimeMillis() + delaySecond * 1000L);
            }
            sendResult = this.baseProducer.send(msg);
            flg = true;
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
        MessageResult rs = new MessageResult(flg, sendResult, msg, "action", "SEND");
        logOnsMessage.info(JSON.toJSONString((Object)rs, (boolean)false));
        return rs;
    }

    public MessageResult sendTaskMessage(MessageQueueTagEnum tag, MessageParam message, Date time) {
        boolean flg = false;
        SendResult sendResult = new SendResult();
        Message msg = new Message();
        try {
            msg.setTopic(this.jmsOnsConfig.getTopic_task_big());
            msg.setTag(tag.getValue());
            msg.setBody(Serializer.serialize((Object)message.getParams()));
            msg.setKey(RandomUtils.generateId() + ":" + (message.getKey() == null ? "" : message.getKey()));
            if (time != null) {
                msg.setStartDeliverTime(time.getTime());
            }
            sendResult = this.baseProducer.send(msg);
            flg = true;
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
        MessageResult rs = new MessageResult(flg, sendResult, msg, "action", "SEND");
        logOnsMessage.info(JSON.toJSONString((Object)rs, (boolean)false));
        return rs;
    }

    public MessageResult sendBigMessage(MessageQueueTagEnum tag, MessageParam message) {
        boolean flg = false;
        SendResult sendResult = new SendResult();
        Message msg = new Message();
        try {
            msg.setTopic(this.jmsOnsConfig.getTopic_task_big());
            msg.setTag(tag.getValue());
            msg.setBody(Serializer.serialize((Object)message.getParams()));
            msg.setKey(RandomUtils.generateId() + ":" + (message.getKey() == null ? "" : message.getKey()));
            sendResult = this.baseProducer.send(msg);
            flg = true;
        }
        catch (Exception e) {
            log.error("\u5927\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
        MessageResult rs = new MessageResult(flg, sendResult, msg, "action", "SEND");
        logOnsMessage.info(JSON.toJSONString((Object)rs, (boolean)false));
        return rs;
    }

    public MessageResult sendOrderMessage(MessageQueueTagEnum tag, MessageParam message, String shardingKey) {
        boolean flg = false;
        SendResult sendResult = new SendResult();
        Message msg = new Message();
        try {
            msg.setTopic(this.jmsOnsConfig.getTopic_order());
            msg.setTag(tag.getValue());
            msg.setBody(Serializer.serialize((Object)message.getParams()));
            msg.setKey(RandomUtils.generateId() + ":" + (message.getKey() == null ? "" : message.getKey()));
            sendResult = this.orderProducer.send(msg, shardingKey);
            flg = true;
        }
        catch (Exception e) {
            log.error("\u987a\u5e8f\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
        MessageResult rs = new MessageResult(flg, sendResult, msg, "orderAction", "SEND");
        logOnsMessage.info(JSON.toJSONString((Object)rs, (boolean)false));
        return rs;
    }

    public MessageResult sendNormalMessage(MessageQueueTagEnum tag, MessageParam message) {
        boolean flg = false;
        SendResult sendResult = new SendResult();
        Message msg = new Message();
        try {
            msg.setTopic(this.jmsOnsConfig.getTopic_wechatMessage());
            msg.setTag(tag.getValue());
            msg.setBody(Serializer.serialize((Object)message.getParams()));
            msg.setKey(RandomUtils.generateId() + ":" + (message.getKey() == null ? "" : message.getKey()));
            sendResult = this.baseProducer.send(msg);
            flg = true;
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u6d88\u606f\u4e13\u7528\u63a8\u9001\u961f\u5217", (Throwable)e);
        }
        MessageResult rs = new MessageResult(flg, sendResult, msg, "action", "SEND");
        logOnsMessage.info(JSON.toJSONString((Object)rs, (boolean)false));
        return rs;
    }
}

