/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.core.jms;

import cc.lechun.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.core.jms.AbstractOrderMessageListener;
import cc.lechun.mall.iservice.jms.MessageOrderQueueInterface;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.order.ConsumeOrderContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="orderMessageListener")
public class OrderMessageListener
extends AbstractOrderMessageListener {
    private final Map<String, MessageOrderQueueInterface> messageOrderQueueInterfaceMap = new ConcurrentHashMap<String, MessageOrderQueueInterface>();

    @Autowired
    public OrderMessageListener(Map<String, MessageOrderQueueInterface> messageOrderQueueInterfaceMap) {
        this.messageOrderQueueInterfaceMap.clear();
        messageOrderQueueInterfaceMap.forEach((k, v) -> this.messageOrderQueueInterfaceMap.put((String)k, (MessageOrderQueueInterface)v));
    }

    @Override
    public boolean receive(Message message, ConsumeOrderContext context) {
        try {
            String name = MessageQueueTagEnum.getName((String)message.getTag());
            if (name.isEmpty()) {
                return false;
            }
            if (this.messageOrderQueueInterfaceMap.get(message.getTag()) != null) {
                return this.messageOrderQueueInterfaceMap.get(message.getTag()).receive(message, context);
            }
        }
        catch (Exception e) {
            this.log.error("\u987a\u5e8f\u6d88\u606f\u5904\u7406\u5931\u8d25,\u6d88\u606ftag\uff1a" + message.getTag() + "," + message.getMsgID(), (Throwable)e);
        }
        return false;
    }
}

