/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.config.artemis;

import cc.lechun.erp.domain.common.ErpCommonDoMain;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class ArtemisJmsConfig {
    private String url = "tcp://8.147.133.97:61616";
    private String user = "admin";
    private String password = "admin123456$";
    private static Logger log = LoggerFactory.getLogger((String)ErpCommonDoMain.class.getName());

    @Bean(name={"artemisFactory"})
    public ActiveMQConnectionFactory artemisFactory() {
        return new ActiveMQConnectionFactory(this.url, this.user, this.password);
    }

    @Bean(name={"listenerArtemisFactory"})
    public JmsListenerContainerFactory<?> listenerArtemisFactory(ActiveMQConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory((ConnectionFactory)connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(true));
        factory.setDestinationResolver(new DestinationResolver(){

            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                if (pubSubDomain) {
                    return session.createTopic(destinationName);
                }
                return session.createQueue(destinationName);
            }
        });
        return factory;
    }

    @Bean(name={"jmsTemplateArtemis"})
    public static JmsTemplate jmsTemplateArtemis(@Qualifier(value="artemisFactory") ConnectionFactory connectionFactory) {
        JmsTemplate template = new JmsTemplate(connectionFactory);
        template.setPubSubDomain(true);
        return template;
    }
}

