/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common;

import cc.lechun.erp.config.entity.Cache;
import cc.lechun.erp.config.imp.CacheMainDel;
import cc.lechun.erp.dao.common.ErpCommonMapper;
import cc.lechun.erp.domain.common.entity.Cust;
import cc.lechun.erp.domain.common.entity.CustClass;
import cc.lechun.erp.domain.common.entity.Dept;
import cc.lechun.erp.domain.common.entity.Dict;
import cc.lechun.erp.domain.common.entity.Emp;
import cc.lechun.erp.domain.common.entity.Factory;
import cc.lechun.erp.domain.common.entity.Freshness;
import cc.lechun.erp.domain.common.entity.Logistic;
import cc.lechun.erp.domain.common.entity.Mat;
import cc.lechun.erp.domain.common.entity.MatClass;
import cc.lechun.erp.domain.common.entity.Packing;
import cc.lechun.erp.domain.common.entity.Shop;
import cc.lechun.erp.domain.common.entity.ShopLogistic;
import cc.lechun.erp.domain.common.entity.Store;
import cc.lechun.erp.domain.common.entity.Suit;
import cc.lechun.erp.domain.common.entity.Supplier;
import cc.lechun.erp.util.MyCopy;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpCommonDoMain {
    private Logger log = LoggerFactory.getLogger((String)"ErpCache");
    public static String id_ = "id";
    public static String code_ = "code";
    public static String name_ = "name";
    public static String outCode_ = "outCode";
    @Autowired
    private ErpCommonMapper erpCommonMapper;
    @Autowired
    private CacheMainDel cacheMainDel;
    public static ConcurrentHashMap<String, Mat> matMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Suit> suitMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Cust> custMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Store> storeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Factory> factoryMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Dept> deptMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Logistic> logisticMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, MatClass> classMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, CustClass> custClassMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Supplier> supplierMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Shop> shopMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Emp> empMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Freshness> freshnessMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Dict> dictMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, ShopLogistic> shopLogisticMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Packing> packingNumMap = new ConcurrentHashMap();
    ConcurrentHashMap<String, Boolean> daysToHoursMap = new ConcurrentHashMap();
    ConcurrentHashMap<String, Boolean> dateTimeToDateMap = new ConcurrentHashMap();

    private Mat getMat(String id, String code, String name, String outCode) {
        Mat obj = null;
        String key = this.getKey(id, code, name, outCode, null);
        if (matMap.containsKey(key)) {
            obj = matMap.get(key);
        } else {
            obj = this.erpCommonMapper.getMat(id, code, name, outCode);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), obj.getCbarcode(), matMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Mat getMatById(String id) {
        return this.getMat(id, null, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Mat getMatByCode(String code) {
        return this.getMat(null, code, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Mat getMatByName(String name) {
        return this.getMat(null, null, name, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Mat getMatByCbarcode(String cbarcode) {
        return this.getMat(null, null, null, cbarcode);
    }

    private Suit getSuit(String id, String code, String name, String outCode, String shopId) {
        Suit obj = null;
        String key = this.getKey(id, code, name, outCode, shopId);
        if (suitMap.containsKey(key)) {
            obj = suitMap.get(key);
        } else {
            obj = this.erpCommonMapper.getSuit(id, code, name, outCode, shopId);
            if (obj != null) {
                obj.setList(this.erpCommonMapper.getSuitMat(obj.getCguid()));
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), suitMap, obj, shopId);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Suit getSuitById(String id) {
        return this.getSuit(id, null, null, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Suit getSuitByCode(String code, String shopId) {
        return this.getSuit(null, code, null, null, shopId);
    }

    @Transactional(rollbackFor={Exception.class})
    public Suit getSuitByName(String name, String shopId) {
        return this.getSuit(null, null, name, null, shopId);
    }

    @Transactional(rollbackFor={Exception.class})
    public Suit getSuitByOutCode(String outCode, String shopId) {
        return this.getSuit(null, null, null, outCode, shopId);
    }

    private Cust getCust(String id, String code, String name) {
        Cust obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (custMap.containsKey(key)) {
            obj = custMap.get(key);
        } else {
            obj = this.erpCommonMapper.getCust(id, code, name);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), null, custMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Cust getCustById(String id) {
        return this.getCust(id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Cust getCustByCode(String code) {
        return this.getCust(null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Cust getCustByName(String name) {
        return this.getCust(null, null, name);
    }

    private Store getStore(String id, String code, String name) {
        Store obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (storeMap.containsKey(key)) {
            obj = storeMap.get(key);
        } else {
            obj = this.erpCommonMapper.getStore(id, code, name);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), null, storeMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Store getStoreById(String id) {
        return this.getStore(id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Store getStoreByCode(String code) {
        return this.getStore(null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Store getStoreByName(String name) {
        return this.getStore(null, null, name);
    }

    private Factory getFactory(String id, String code, String name) {
        Factory obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (factoryMap.containsKey(key)) {
            obj = factoryMap.get(key);
        } else {
            obj = this.erpCommonMapper.getFactory(id, code, name);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), null, factoryMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Factory getFactoryById(String id) {
        return this.getFactory(id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Factory getFactoryByCode(String code) {
        return this.getFactory(null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Factory getFactoryByName(String name) {
        return this.getFactory(null, null, name);
    }

    private Dept getDept(String id, String code, String name) {
        Dept obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (deptMap.containsKey(key)) {
            obj = deptMap.get(key);
        } else {
            obj = this.erpCommonMapper.getDept(id, code, name);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), null, deptMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Dept getDeptById(String id) {
        return this.getDept(id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Dept getDeptByCode(String code) {
        return this.getDept(null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Dept getDeptByName(String name) {
        return this.getDept(null, null, name);
    }

    private Logistic getLogistic(String id, String code, String name, String outCode) {
        Logistic obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (logisticMap.containsKey(key)) {
            obj = logisticMap.get(key);
        } else {
            obj = this.erpCommonMapper.getLogistic(id, code, name, outCode);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), logisticMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Logistic getLogisticById(String id) {
        return this.getLogistic(id, null, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Logistic getLogisticByCode(String code) {
        return this.getLogistic(null, code, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Logistic getLogisticByName(String name) {
        return this.getLogistic(null, null, name, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Logistic getLogisticByOutCode(String outCode) {
        return this.getLogistic(null, null, null, outCode);
    }

    private MatClass getMatClass(String id, String code, String name) {
        MatClass obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (classMap.containsKey(key)) {
            obj = classMap.get(key);
        } else {
            obj = this.erpCommonMapper.getMatClass(id, code, name);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), null, classMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public MatClass getMatClassById(String id) {
        return this.getMatClass(id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public MatClass getMatClassByCode(String code) {
        return this.getMatClass(null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public MatClass getMatClassByName(String name) {
        return this.getMatClass(null, null, name);
    }

    private CustClass getCustClass(String id, String code, String name) {
        CustClass obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (custClassMap.containsKey(key)) {
            obj = custClassMap.get(key);
        } else {
            obj = this.erpCommonMapper.getCustClass(id, code, name);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), null, custClassMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public CustClass getgetCustClassById(String id) {
        return this.getCustClass(id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public CustClass getgetCustClassByCode(String code) {
        return this.getCustClass(null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public CustClass getgetCustClassByName(String name) {
        return this.getCustClass(null, null, name);
    }

    private Supplier getSupplier(String id, String code, String name) {
        Supplier obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (supplierMap.containsKey(key)) {
            obj = supplierMap.get(key);
        } else {
            obj = this.erpCommonMapper.getSupplier(id, code, name);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), null, supplierMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Supplier getSupplierById(String id) {
        return this.getSupplier(id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Supplier getSupplierByCode(String code) {
        return this.getSupplier(null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Supplier getSupplierByName(String name) {
        return this.getSupplier(null, null, name);
    }

    private Shop getShop(String id, String code, String name, String outCode) {
        Shop obj = null;
        String key = this.getKey(id, code, name, outCode, null);
        if (shopMap.containsKey(key)) {
            obj = shopMap.get(key);
        } else {
            obj = this.erpCommonMapper.getShop(id, code, name, outCode);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), shopMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Shop getShopById(String id) {
        return this.getShop(id, null, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Shop getShopByCode(String code) {
        return this.getShop(null, code, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Shop getShopByName(String name) {
        return this.getShop(null, null, name, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Shop getShopByOutCode(String outCode) {
        return this.getShop(null, null, null, outCode);
    }

    private Emp getEmp(String id, String code, String name) {
        Emp obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (empMap.containsKey(key)) {
            obj = empMap.get(key);
        } else {
            obj = this.erpCommonMapper.getEmp(id, code, name);
            if (obj != null) {
                this.add(obj.getCguid(), obj.getCode(), obj.getName(), null, empMap, obj, null);
            }
        }
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public Emp getEmpById(String id) {
        return this.getEmp(id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Emp getEmpByCode(String code) {
        return this.getEmp(null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Emp getEmpByName(String name) {
        return this.getEmp(null, null, name);
    }

    @Transactional(rollbackFor={Exception.class})
    public Freshness getFreshness(String customerId, String storeId, String matId) {
        String shelfLifeClass = this.getMatById(matId).getShelfLifeClass();
        if (StringUtils.isNotBlank((CharSequence)shelfLifeClass)) {
            String key = customerId + "|" + storeId + "|" + shelfLifeClass;
            if (freshnessMap.get(key) != null) {
                return MyCopy.copy(freshnessMap.get(key));
            }
            Freshness find = this.erpCommonMapper.getFreshness(customerId, storeId, shelfLifeClass);
            if (null != find) {
                freshnessMap.put(key, find);
                return find;
            }
        }
        return null;
    }

    private Dict getDict(String parentCode, String id, String code, String name) {
        String key = parentCode + this.getKey(id, code, name, null, null);
        if (dictMap.get(key) != null) {
            return MyCopy.copy(dictMap.get(key));
        }
        Dict find = this.erpCommonMapper.getDict(parentCode, id, code, name);
        if (null != find) {
            dictMap.put(key, find);
            return find;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Dict getDictById(String parentCode, String id) {
        return this.getDict(parentCode, id, null, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Dict getDictByCode(String parentCode, String code) {
        return this.getDict(parentCode, null, code, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Dict getDictByName(String parentCode, String name) {
        return this.getDict(parentCode, null, null, name);
    }

    @Transactional(rollbackFor={Exception.class})
    public ShopLogistic getShopLogistic(String shopId, String logisticId) {
        String key = shopId + "|" + logisticId;
        if (shopLogisticMap.get(key) != null) {
            return MyCopy.copy(shopLogisticMap.get(key));
        }
        ShopLogistic find = this.erpCommonMapper.getShopLogistic(shopId, logisticId);
        if (null != find) {
            shopLogisticMap.put(key, find);
            return find;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Packing getPacking(String custId, String matId) {
        String key = custId + "|" + matId;
        if (packingNumMap.get(key) != null) {
            return MyCopy.copy(packingNumMap.get(key));
        }
        Packing find = this.erpCommonMapper.getPacking(custId, matId);
        if (null != find) {
            packingNumMap.put(key, MyCopy.copy(find));
            return find;
        }
        return null;
    }

    private void clear() {
        matMap.clear();
        custMap.clear();
        custClassMap.clear();
        storeMap.clear();
        factoryMap.clear();
        supplierMap.clear();
        deptMap.clear();
        classMap.clear();
        logisticMap.clear();
        shopMap.clear();
        empMap.clear();
        packingNumMap.clear();
        freshnessMap.clear();
        dictMap.clear();
        shopLogisticMap.clear();
        this.daysToHoursMap.clear();
        this.dateTimeToDateMap.clear();
        suitMap.clear();
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean daysToHours(String cargo_master_code) {
        if (this.daysToHoursMap.containsKey(cargo_master_code)) {
            return this.daysToHoursMap.get(cargo_master_code);
        }
        String find = this.erpCommonMapper.wmsDaysToHours(cargo_master_code);
        if (StringUtils.isNotBlank((CharSequence)find)) {
            this.daysToHoursMap.put(cargo_master_code, true);
            return true;
        }
        this.daysToHoursMap.put(cargo_master_code, false);
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean dateTimeToDate(String cargo_master_code) {
        if (this.dateTimeToDateMap.containsKey(cargo_master_code)) {
            return this.dateTimeToDateMap.get(cargo_master_code);
        }
        String find = this.erpCommonMapper.wmsdateTimeToDate(cargo_master_code);
        if (StringUtils.isNotBlank((CharSequence)find)) {
            this.dateTimeToDateMap.put(cargo_master_code, true);
            return true;
        }
        this.dateTimeToDateMap.put(cargo_master_code, false);
        return false;
    }

    public void deleteCache(TextMessage message) throws JMSException {
        Cache cache = null;
        try {
            cache = (Cache)JSONObject.parseObject((String)message.getText(), Cache.class);
        }
        catch (Exception e) {
            return;
        }
        if (null == cache || StringUtils.isBlank((CharSequence)cache.getType()) || StringUtils.isBlank((CharSequence)cache.getKey())) {
            return;
        }
        if (cache.getType().equals("Cust")) {
            Cust obj = this.getCustById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, custMap, null);
            }
            packingNumMap.clear();
            freshnessMap.clear();
        } else if (cache.getType().equals("CustClass")) {
            custClassMap.clear();
            custMap.clear();
        } else if (cache.getType().equals("Dept")) {
            Dept obj = this.getDeptById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, deptMap, null);
            }
        } else if (cache.getType().equals("Factory")) {
            Factory obj = this.getFactoryById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, factoryMap, null);
            }
        } else if (cache.getType().equals("Logistic")) {
            Logistic obj = this.getLogisticById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), logisticMap, null);
            }
            shopLogisticMap.clear();
        } else if (cache.getType().equals("Mat")) {
            Mat obj = this.getMatById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getCbarcode(), matMap, null);
            }
        } else if (cache.getType().equals("MatClass")) {
            MatClass obj = this.getMatClassById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, classMap, null);
            }
        } else if (cache.getType().equals("Shop")) {
            Shop obj = this.getShopById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), shopMap, null);
            }
        } else if (cache.getType().equals("Store")) {
            Store obj = this.getStoreById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, storeMap, null);
            }
        } else if (cache.getType().equals("Emp")) {
            Emp obj = this.getEmpById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, empMap, null);
            }
        } else if (cache.getType().equals("Suit")) {
            Suit obj = this.getSuitById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, suitMap, obj.getShopId());
            }
        } else if (cache.getType().equals("Supplier")) {
            Supplier obj = this.getSupplierById(cache.getKey());
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, supplierMap, null);
            }
        } else if (cache.getType().equals("Dict")) {
            dictMap.clear();
        } else if (cache.getType().equals("all")) {
            this.clear();
        }
    }

    private String getKey(String id, String code, String name, String outCode, String other) {
        String key = "";
        if (StringUtils.isNotBlank((CharSequence)id)) {
            key = id_ + id;
        } else if (StringUtils.isNotBlank((CharSequence)code)) {
            key = code_ + code + (other == null ? "" : "|" + other);
        } else if (StringUtils.isNotBlank((CharSequence)name)) {
            key = name_ + name + (other == null ? "" : "|" + other);
        } else if (StringUtils.isNotBlank((CharSequence)outCode)) {
            key = outCode_ + outCode + (other == null ? "" : "|" + other);
        }
        return key;
    }

    private <T> void deleteKey(String id, String code, String name, String outCode, Map<String, T> mapL, String other) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            mapL.remove(id_ + id);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            mapL.remove(code_ + code + (other == null ? "" : "|" + other));
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            mapL.remove(name_ + name + (other == null ? "" : "|" + other));
        }
        if (StringUtils.isNotBlank((CharSequence)outCode)) {
            mapL.remove(outCode_ + outCode + (other == null ? "" : "|" + other));
        }
    }

    private <T> void add(String id, String code, String name, String outCode, Map<String, T> mapL, T t, String other) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            mapL.put(id_ + id, t);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            mapL.put(code_ + code + (other == null ? "" : "|" + other), t);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            mapL.put(name_ + name + (other == null ? "" : "|" + other), t);
        }
        if (StringUtils.isNotBlank((CharSequence)outCode)) {
            mapL.put(outCode_ + outCode + (other == null ? "" : "|" + other), t);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveDispatchOrderAccountDetails(String mainId, String storeId) {
        this.erpCommonMapper.saveDispatchOrderAccountDetails(mainId, storeId, "\u53d1\u8d27\u5355", "0");
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveStoreOrderAccountDetails(String mainId, String storeId, String billType, Integer inOuttype) {
        this.erpCommonMapper.saveStoreOrderAccountDetails(mainId, storeId, billType, inOuttype + "");
    }

    @Transactional(rollbackFor={Exception.class})
    public void savePuStoreOrderAccountDetails(String mainId, String storeId) {
        this.erpCommonMapper.savePuStoreOrderAccountDetails(mainId, storeId, "\u91c7\u8d2d\u5165\u5e93\u5355", "1");
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateShopToken(String id, String shopToken) {
        this.erpCommonMapper.updateShopToken(id, shopToken);
        this.cacheMainDel.sendDelete(Shop.delteCache(id));
    }
}

