/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common;

import cc.lechun.erp.config.entity.Cache;
import cc.lechun.erp.config.imp.CacheMainDel;
import cc.lechun.erp.dao.common.ErpCommonMapper;
import cc.lechun.erp.domain.common.entity.Cust;
import cc.lechun.erp.domain.common.entity.CustClass;
import cc.lechun.erp.domain.common.entity.Dept;
import cc.lechun.erp.domain.common.entity.Dict;
import cc.lechun.erp.domain.common.entity.Emp;
import cc.lechun.erp.domain.common.entity.Factory;
import cc.lechun.erp.domain.common.entity.Freshness;
import cc.lechun.erp.domain.common.entity.Logistic;
import cc.lechun.erp.domain.common.entity.Mat;
import cc.lechun.erp.domain.common.entity.MatClass;
import cc.lechun.erp.domain.common.entity.Packing;
import cc.lechun.erp.domain.common.entity.Shop;
import cc.lechun.erp.domain.common.entity.ShopLogistic;
import cc.lechun.erp.domain.common.entity.Store;
import cc.lechun.erp.domain.common.entity.Suit;
import cc.lechun.erp.domain.common.entity.Supplier;
import cc.lechun.erp.util.MyCopy;
import cc.lechun.framework.core.common.SpringGetBeanUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CacheDo {
    private Logger log = LoggerFactory.getLogger((String)"ErpCache");
    public static String id_ = "id";
    public static String code_ = "code";
    public static String name_ = "name";
    public static String outCode_ = "outCode";
    private static ErpCommonMapper erpCommonMapper = (ErpCommonMapper)SpringGetBeanUtil.getBean(ErpCommonMapper.class);
    private static CacheMainDel cacheMainDel = (CacheMainDel)SpringGetBeanUtil.getBean(CacheMainDel.class);
    public static HashMap<String, Mat> matMap = new HashMap();
    public static HashMap<String, Suit> suitMap = new HashMap();
    public static HashMap<String, Cust> custMap = new HashMap();
    public static HashMap<String, Store> storeMap = new HashMap();
    public static HashMap<String, Factory> factoryMap = new HashMap();
    public static HashMap<String, Dept> deptMap = new HashMap();
    public static HashMap<String, Logistic> logisticMap = new HashMap();
    public static HashMap<String, MatClass> classMap = new HashMap();
    public static HashMap<String, CustClass> custClassMap = new HashMap();
    public static HashMap<String, Supplier> supplierMap = new HashMap();
    public static HashMap<String, Shop> shopMap = new HashMap();
    public static HashMap<String, Emp> empMap = new HashMap();
    public static HashMap<String, Freshness> freshnessMap = new HashMap();
    public static HashMap<String, Dict> dictMap = new HashMap();
    public static HashMap<String, ShopLogistic> shopLogisticMap = new HashMap();
    public static HashMap<String, Packing> packingNumMap = new HashMap();
    static HashMap<String, List<String>> anchorMap = new HashMap();
    static HashMap<String, Boolean> daysToHoursMap = new HashMap();
    static HashMap<String, Boolean> dateTimeToDateMap = new HashMap();

    private static Mat getMat(String id, String code, String name, String outCode) {
        Mat obj = null;
        String key = CacheDo.getKey(id, code, name, outCode, null);
        if (matMap.containsKey(key)) {
            obj = matMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)outCode)) && (obj = erpCommonMapper.getMat(id, code, name, outCode)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), obj.getCbarcode(), matMap, obj, null);
        }
        return obj;
    }

    public static Mat getMatById(String id) {
        return CacheDo.getMat(id, null, null, null);
    }

    public static Mat getMatByCode(String code) {
        return CacheDo.getMat(null, code, null, null);
    }

    public static Mat getMatByName(String name) {
        return CacheDo.getMat(null, null, name, null);
    }

    public static Mat getMatByCbarcode(String cbarcode) {
        return CacheDo.getMat(null, null, null, cbarcode);
    }

    private static Suit getSuit(String id, String code, String name, String outCode, String shopId) {
        Suit obj = null;
        String key = CacheDo.getKey(id, code, name, outCode, shopId);
        if (suitMap.containsKey(key)) {
            obj = suitMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)outCode)) && (obj = erpCommonMapper.getSuit(id, code, name, outCode, shopId)) != null) {
            obj.setList(erpCommonMapper.getSuitMat(obj.getCguid()));
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), suitMap, obj, shopId);
        }
        return obj;
    }

    public static Suit getSuitById(String id) {
        return CacheDo.getSuit(id, null, null, null, null);
    }

    public static Suit getSuitByCode(String code, String shopId) {
        return CacheDo.getSuit(null, code, null, null, shopId);
    }

    public static Suit getSuitByName(String name, String shopId) {
        return CacheDo.getSuit(null, null, name, null, shopId);
    }

    public static Suit getSuitByOutCode(String outCode, String shopId) {
        return CacheDo.getSuit(null, null, null, outCode, shopId);
    }

    private static Cust getCust(String id, String code, String name) {
        Cust obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (custMap.containsKey(key)) {
            obj = custMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && (obj = erpCommonMapper.getCust(id, code, name)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), null, custMap, obj, null);
        }
        return obj;
    }

    public static Cust getCustById(String id) {
        return CacheDo.getCust(id, null, null);
    }

    public static Cust getCustByCode(String code) {
        return CacheDo.getCust(null, code, null);
    }

    public static Cust getCustByName(String name) {
        return CacheDo.getCust(null, null, name);
    }

    private static Store getStore(String id, String code, String name) {
        Store obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (storeMap.containsKey(key)) {
            obj = storeMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && (obj = erpCommonMapper.getStore(id, code, name)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), null, storeMap, obj, null);
        }
        return obj;
    }

    public static Store getStoreById(String id) {
        return CacheDo.getStore(id, null, null);
    }

    public static Store getStoreByCode(String code) {
        return CacheDo.getStore(null, code, null);
    }

    public static Store getStoreByName(String name) {
        return CacheDo.getStore(null, null, name);
    }

    private static Factory getFactory(String id, String code, String name) {
        Factory obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (factoryMap.containsKey(key)) {
            obj = factoryMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && (obj = erpCommonMapper.getFactory(id, code, name)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), null, factoryMap, obj, null);
        }
        return obj;
    }

    public static Factory getFactoryById(String id) {
        return CacheDo.getFactory(id, null, null);
    }

    public static Factory getFactoryByCode(String code) {
        return CacheDo.getFactory(null, code, null);
    }

    public static Factory getFactoryByName(String name) {
        return CacheDo.getFactory(null, null, name);
    }

    private static Dept getDept(String id, String code, String name) {
        Dept obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (deptMap.containsKey(key)) {
            obj = deptMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && (obj = erpCommonMapper.getDept(id, code, name)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), null, deptMap, obj, null);
        }
        return obj;
    }

    public static Dept getDeptById(String id) {
        return CacheDo.getDept(id, null, null);
    }

    public static Dept getDeptByCode(String code) {
        return CacheDo.getDept(null, code, null);
    }

    public static Dept getDeptByName(String name) {
        return CacheDo.getDept(null, null, name);
    }

    private static Logistic getLogistic(String id, String code, String name, String outCode) {
        Logistic obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (logisticMap.containsKey(key)) {
            obj = logisticMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)outCode)) && (obj = erpCommonMapper.getLogistic(id, code, name, outCode)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), logisticMap, obj, null);
        }
        return obj;
    }

    public static Logistic getLogisticById(String id) {
        return CacheDo.getLogistic(id, null, null, null);
    }

    public static Logistic getLogisticByCode(String code) {
        return CacheDo.getLogistic(null, code, null, null);
    }

    public static Logistic getLogisticByName(String name) {
        return CacheDo.getLogistic(null, null, name, null);
    }

    public static Logistic getLogisticByOutCode(String outCode) {
        return CacheDo.getLogistic(null, null, null, outCode);
    }

    private static MatClass getMatClass(String id, String code, String name) {
        MatClass obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (classMap.containsKey(key)) {
            obj = classMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && (obj = erpCommonMapper.getMatClass(id, code, name)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), null, classMap, obj, null);
        }
        return obj;
    }

    public static MatClass getMatClassById(String id) {
        return CacheDo.getMatClass(id, null, null);
    }

    public static MatClass getMatClassByCode(String code) {
        return CacheDo.getMatClass(null, code, null);
    }

    public static MatClass getMatClassByName(String name) {
        return CacheDo.getMatClass(null, null, name);
    }

    private static CustClass getCustClass(String id, String code, String name) {
        CustClass obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (custClassMap.containsKey(key)) {
            obj = custClassMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && (obj = erpCommonMapper.getCustClass(id, code, name)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), null, custClassMap, obj, null);
        }
        return obj;
    }

    public static CustClass getgetCustClassById(String id) {
        return CacheDo.getCustClass(id, null, null);
    }

    public static CustClass getgetCustClassByCode(String code) {
        return CacheDo.getCustClass(null, code, null);
    }

    public static CustClass getgetCustClassByName(String name) {
        return CacheDo.getCustClass(null, null, name);
    }

    private static Supplier getSupplier(String id, String code, String name) {
        Supplier obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (supplierMap.containsKey(key)) {
            obj = supplierMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && (obj = erpCommonMapper.getSupplier(id, code, name)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), null, supplierMap, obj, null);
        }
        return obj;
    }

    public static Supplier getSupplierById(String id) {
        return CacheDo.getSupplier(id, null, null);
    }

    public static Supplier getSupplierByCode(String code) {
        return CacheDo.getSupplier(null, code, null);
    }

    public static Supplier getSupplierByName(String name) {
        return CacheDo.getSupplier(null, null, name);
    }

    private static Shop getShop(String id, String code, String name, String outCode) {
        Shop obj = null;
        String key = CacheDo.getKey(id, code, name, outCode, null);
        if (shopMap.containsKey(key)) {
            obj = shopMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)outCode)) && (obj = erpCommonMapper.getShop(id, code, name, outCode)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), shopMap, obj, null);
        }
        return obj;
    }

    public static Shop getShopById(String id) {
        return CacheDo.getShop(id, null, null, null);
    }

    public static Shop getShopByCode(String code) {
        return CacheDo.getShop(null, code, null, null);
    }

    public static Shop getShopByName(String name) {
        return CacheDo.getShop(null, null, name, null);
    }

    public static Shop getShopByOutCode(String outCode) {
        return CacheDo.getShop(null, null, null, outCode);
    }

    private static Emp getEmp(String id, String code, String name) {
        Emp obj = null;
        String key = CacheDo.getKey(id, code, name, null, null);
        if (empMap.containsKey(key)) {
            obj = empMap.get(key);
        } else if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && (obj = erpCommonMapper.getEmp(id, code, name)) != null) {
            CacheDo.add(obj.getCguid(), obj.getCode(), obj.getName(), null, empMap, obj, null);
        }
        return obj;
    }

    public static Emp getEmpById(String id) {
        return CacheDo.getEmp(id, null, null);
    }

    public static Emp getEmpByCode(String code) {
        return CacheDo.getEmp(null, code, null);
    }

    public static Emp getEmpByName(String name) {
        return CacheDo.getEmp(null, null, name);
    }

    public static Freshness getFreshness(String customerId, String storeId, String matId) {
        String shelfLifeClass = CacheDo.getMatById(matId).getShelfLifeClass();
        if (StringUtils.isNotBlank((CharSequence)shelfLifeClass)) {
            Freshness find;
            String key = customerId + "|" + storeId + "|" + shelfLifeClass;
            if (freshnessMap.get(key) != null) {
                return MyCopy.copy(freshnessMap.get(key));
            }
            if (StringUtils.isNotBlank((CharSequence)customerId) && StringUtils.isNotBlank((CharSequence)storeId) && StringUtils.isNotBlank((CharSequence)shelfLifeClass) && null != (find = erpCommonMapper.getFreshness(customerId, storeId, shelfLifeClass))) {
                freshnessMap.put(key, find);
                return find;
            }
        }
        return null;
    }

    private static Dict getDict(String parentCode, String id, String code, String name) {
        Dict find;
        String key = parentCode + CacheDo.getKey(id, code, name, null, null);
        if (dictMap.get(key) != null) {
            return MyCopy.copy(dictMap.get(key));
        }
        if ((StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) && null != (find = erpCommonMapper.getDict(parentCode, id, code, name))) {
            dictMap.put(key, find);
            return find;
        }
        return null;
    }

    public static Dict getDictById(String parentCode, String id) {
        return CacheDo.getDict(parentCode, id, null, null);
    }

    public static Dict getDictByCode(String parentCode, String code) {
        return CacheDo.getDict(parentCode, null, code, null);
    }

    public static Dict getDictByName(String parentCode, String name) {
        return CacheDo.getDict(parentCode, null, null, name);
    }

    public ShopLogistic getShopLogistic(String shopId, String logisticId) {
        ShopLogistic find;
        String key = shopId + "|" + logisticId;
        if (shopLogisticMap.get(key) != null) {
            return MyCopy.copy(shopLogisticMap.get(key));
        }
        if (StringUtils.isNotBlank((CharSequence)shopId) && StringUtils.isNotBlank((CharSequence)logisticId) && null != (find = erpCommonMapper.getShopLogistic(shopId, logisticId))) {
            shopLogisticMap.put(key, find);
            return find;
        }
        return null;
    }

    public static Packing getPacking(String custId, String matId) {
        Packing find;
        String key = custId + "|" + matId;
        if (packingNumMap.get(key) != null) {
            return MyCopy.copy(packingNumMap.get(key));
        }
        if (StringUtils.isNotBlank((CharSequence)custId) && StringUtils.isNotBlank((CharSequence)matId) && null != (find = erpCommonMapper.getPacking(custId, matId))) {
            packingNumMap.put(key, MyCopy.copy(find));
            return find;
        }
        return null;
    }

    private static void clear() {
        matMap.clear();
        custMap.clear();
        custClassMap.clear();
        storeMap.clear();
        factoryMap.clear();
        supplierMap.clear();
        deptMap.clear();
        classMap.clear();
        logisticMap.clear();
        shopMap.clear();
        empMap.clear();
        packingNumMap.clear();
        freshnessMap.clear();
        dictMap.clear();
        shopLogisticMap.clear();
        daysToHoursMap.clear();
        dateTimeToDateMap.clear();
        suitMap.clear();
        anchorMap.clear();
    }

    public static List<String> getAnchorIds(String plateFrom) {
        List<String> anchorIds;
        if (anchorMap.containsKey(plateFrom)) {
            return anchorMap.get(plateFrom);
        }
        if (StringUtils.isNotBlank((CharSequence)plateFrom) && null != (anchorIds = erpCommonMapper.getAnchorIds(plateFrom)) && !anchorIds.isEmpty()) {
            anchorMap.put(plateFrom, anchorIds);
            return anchorIds;
        }
        return null;
    }

    public static boolean daysToHours(String cargo_master_code) {
        if (daysToHoursMap.containsKey(cargo_master_code)) {
            return daysToHoursMap.get(cargo_master_code);
        }
        String find = erpCommonMapper.wmsDaysToHours(cargo_master_code);
        if (StringUtils.isNotBlank((CharSequence)find)) {
            daysToHoursMap.put(cargo_master_code, true);
            return true;
        }
        daysToHoursMap.put(cargo_master_code, false);
        return false;
    }

    public boolean dateTimeToDate(String cargo_master_code) {
        if (dateTimeToDateMap.containsKey(cargo_master_code)) {
            return dateTimeToDateMap.get(cargo_master_code);
        }
        String find = erpCommonMapper.wmsdateTimeToDate(cargo_master_code);
        if (StringUtils.isNotBlank((CharSequence)find)) {
            dateTimeToDateMap.put(cargo_master_code, true);
            return true;
        }
        dateTimeToDateMap.put(cargo_master_code, false);
        return false;
    }

    public static void deleteCache(TextMessage message) throws JMSException {
        Cache cache = null;
        try {
            cache = (Cache)JSONObject.parseObject((String)message.getText(), Cache.class);
        }
        catch (Exception e) {
            return;
        }
        if (null == cache || StringUtils.isBlank((CharSequence)cache.getType()) || StringUtils.isBlank((CharSequence)cache.getKey())) {
            return;
        }
        if (cache.getType().equals("Cust")) {
            Cust obj = CacheDo.getCustById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, custMap, null);
            }
            packingNumMap.clear();
            freshnessMap.clear();
        } else if (cache.getType().equals("CustClass")) {
            custClassMap.clear();
            custMap.clear();
        } else if (cache.getType().equals("Dept")) {
            Dept obj = CacheDo.getDeptById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, deptMap, null);
            }
        } else if (cache.getType().equals("Factory")) {
            Factory obj = CacheDo.getFactoryById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, factoryMap, null);
            }
        } else if (cache.getType().equals("Logistic")) {
            Logistic obj = CacheDo.getLogisticById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), logisticMap, null);
            }
            shopLogisticMap.clear();
        } else if (cache.getType().equals("Mat")) {
            Mat obj = CacheDo.getMatById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getCbarcode(), matMap, null);
            }
        } else if (cache.getType().equals("MatClass")) {
            MatClass obj = CacheDo.getMatClassById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, classMap, null);
            }
        } else if (cache.getType().equals("Shop")) {
            Shop obj = CacheDo.getShopById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), shopMap, null);
            }
            anchorMap.clear();
        } else if (cache.getType().equals("Store")) {
            Store obj = CacheDo.getStoreById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, storeMap, null);
            }
        } else if (cache.getType().equals("Emp")) {
            Emp obj = CacheDo.getEmpById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, empMap, null);
            }
        } else if (cache.getType().equals("Suit")) {
            Suit obj = CacheDo.getSuitById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, suitMap, obj.getShopId());
            }
        } else if (cache.getType().equals("Supplier")) {
            Supplier obj = CacheDo.getSupplierById(cache.getKey());
            if (null != obj) {
                CacheDo.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, supplierMap, null);
            }
        } else if (cache.getType().equals("Dict")) {
            dictMap.clear();
        } else if (cache.getType().equals("all")) {
            CacheDo.clear();
        }
    }

    private static String getKey(String id, String code, String name, String outCode, String other) {
        String key = "";
        if (StringUtils.isNotBlank((CharSequence)id)) {
            key = id_ + id;
        } else if (StringUtils.isNotBlank((CharSequence)code)) {
            key = code_ + code + (other == null ? "" : "|" + other);
        } else if (StringUtils.isNotBlank((CharSequence)name)) {
            key = name_ + name + (other == null ? "" : "|" + other);
        } else if (StringUtils.isNotBlank((CharSequence)outCode)) {
            key = outCode_ + outCode + (other == null ? "" : "|" + other);
        }
        return key;
    }

    private static <T> void deleteKey(String id, String code, String name, String outCode, Map<String, T> mapL, String other) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            mapL.remove(id_ + id);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            mapL.remove(code_ + code + (other == null ? "" : "|" + other));
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            mapL.remove(name_ + name + (other == null ? "" : "|" + other));
        }
        if (StringUtils.isNotBlank((CharSequence)outCode)) {
            mapL.remove(outCode_ + outCode + (other == null ? "" : "|" + other));
        }
    }

    private static <T> void add(String id, String code, String name, String outCode, Map<String, T> mapL, T t, String other) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            mapL.put(id_ + id, t);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            mapL.put(code_ + code + (other == null ? "" : "|" + other), t);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            mapL.put(name_ + name + (other == null ? "" : "|" + other), t);
        }
        if (StringUtils.isNotBlank((CharSequence)outCode)) {
            mapL.put(outCode_ + outCode + (other == null ? "" : "|" + other), t);
        }
    }

    public static void saveDispatchOrderAccountDetails(String mainId, String storeId) {
        erpCommonMapper.saveDispatchOrderAccountDetails(mainId, storeId, "\u53d1\u8d27\u5355", "0");
    }

    public static void saveStoreOrderAccountDetails(String mainId, String storeId, String billType, Integer inOuttype) {
        erpCommonMapper.saveStoreOrderAccountDetails(mainId, storeId, billType, inOuttype + "");
    }

    public static void savePuStoreOrderAccountDetails(String mainId, String storeId) {
        erpCommonMapper.savePuStoreOrderAccountDetails(mainId, storeId, "\u91c7\u8d2d\u5165\u5e93\u5355", "1");
    }

    public static void updateShopToken(String id, String shopToken) {
        erpCommonMapper.updateShopToken(id, shopToken);
        cacheMainDel.sendDelete(Shop.delteCache(id));
    }
}

