/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common;

import cc.lechun.erp.config.entity.Cache;
import cc.lechun.erp.config.imp.CacheMainDel;
import cc.lechun.erp.dao.common.ErpCommonMapper;
import cc.lechun.erp.domain.common.entity.Cust;
import cc.lechun.erp.domain.common.entity.CustClass;
import cc.lechun.erp.domain.common.entity.Dept;
import cc.lechun.erp.domain.common.entity.Dict;
import cc.lechun.erp.domain.common.entity.Emp;
import cc.lechun.erp.domain.common.entity.Factory;
import cc.lechun.erp.domain.common.entity.Freshness;
import cc.lechun.erp.domain.common.entity.Logistic;
import cc.lechun.erp.domain.common.entity.Mat;
import cc.lechun.erp.domain.common.entity.MatClass;
import cc.lechun.erp.domain.common.entity.Packing;
import cc.lechun.erp.domain.common.entity.Shop;
import cc.lechun.erp.domain.common.entity.ShopLogistic;
import cc.lechun.erp.domain.common.entity.Store;
import cc.lechun.erp.domain.common.entity.Suit;
import cc.lechun.erp.domain.common.entity.Supplier;
import cc.lechun.erp.util.MyCopy;
import cc.lechun.framework.core.common.SpringGetBeanUtil;
import cc.lechun.framework.core.database.config.dbconfig.SqlPrintInterceptor;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpCommonDoMain {
    private Logger log = LoggerFactory.getLogger((String)"ErpCache");
    public static String id_ = "id";
    public static String code_ = "code";
    public static String name_ = "name";
    public static String outCode_ = "outCode";
    @Autowired
    private ErpCommonMapper erpCommonMapper;
    public static HashMap<String, Mat> matMap = new HashMap();
    public static HashMap<String, Suit> suitMap = new HashMap();
    public static HashMap<String, Cust> custMap = new HashMap();
    public static HashMap<String, Store> storeMap = new HashMap();
    public static HashMap<String, Factory> factoryMap = new HashMap();
    public static HashMap<String, Dept> deptMap = new HashMap();
    public static HashMap<String, Logistic> logisticMap = new HashMap();
    public static HashMap<String, MatClass> classMap = new HashMap();
    public static HashMap<String, CustClass> custClassMap = new HashMap();
    public static HashMap<String, Supplier> supplierMap = new HashMap();
    public static HashMap<String, Shop> shopMap = new HashMap();
    public static HashMap<String, Emp> empMap = new HashMap();
    public static HashMap<String, Freshness> freshnessMap = new HashMap();
    public static HashMap<String, Dict> dictMap = new HashMap();
    public static HashMap<String, ShopLogistic> shopLogisticMap = new HashMap();
    public static HashMap<String, Packing> packingNumMap = new HashMap();
    HashMap<String, List<String>> anchorMap = new HashMap();
    HashMap<String, Boolean> daysToHoursMap = new HashMap();
    HashMap<String, Boolean> dateTimeToDateMap = new HashMap();
    public static HashMap<String, List<Mat>> matListMap = new HashMap();
    public static HashMap<String, List<Suit>> suitListMap = new HashMap();
    public static HashMap<String, List<Cust>> custListMap = new HashMap();
    public static HashMap<String, List<Store>> storeListMap = new HashMap();

    private Mat getMat(String id, String code, String name, String outCode) {
        Mat obj = null;
        String key = this.getKey(id, code, name, outCode, null);
        if (matMap.containsKey(key)) {
            obj = matMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)outCode)) {
            obj = this.erpCommonMapper.getMat(id, code, name, outCode);
            this.add(id, code, name, outCode, matMap, obj, null);
        }
        return obj;
    }

    public Mat getMatById(String id) {
        return this.getMat(id, null, null, null);
    }

    public Mat getMatByCode(String code) {
        return this.getMat(null, code, null, null);
    }

    public Mat getMatByName(String name) {
        return this.getMat(null, null, name, null);
    }

    public Mat getMatByCbarcode(String cbarcode) {
        return this.getMat(null, null, null, cbarcode);
    }

    private Suit getSuit(String id, String code, String name, String outCode, String shopId) {
        Suit obj = null;
        String key = this.getKey(id, code, name, outCode, shopId);
        if (suitMap.containsKey(key)) {
            obj = suitMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)outCode)) {
            obj = this.erpCommonMapper.getSuit(id, code, name, outCode, shopId);
            obj.setList(this.erpCommonMapper.getSuitMat(obj.getCguid()));
            this.add(id, code, name, outCode, suitMap, obj, shopId);
        }
        return obj;
    }

    public Suit getSuitById(String id) {
        return this.getSuit(id, null, null, null, null);
    }

    public Suit getSuitByCode(String code, String shopId) {
        return this.getSuit(null, code, null, null, shopId);
    }

    public Suit getSuitByName(String name, String shopId) {
        return this.getSuit(null, null, name, null, shopId);
    }

    public Suit getSuitByOutCode(String outCode, String shopId) {
        return this.getSuit(null, null, null, outCode, shopId);
    }

    private Cust getCust(String id, String code, String name) {
        Cust obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (custMap.containsKey(key)) {
            obj = custMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            obj = this.erpCommonMapper.getCust(id, code, name);
            this.add(id, code, name, null, custMap, obj, null);
        }
        return obj;
    }

    public Cust getCustById(String id) {
        return this.getCust(id, null, null);
    }

    public Cust getCustByCode(String code) {
        return this.getCust(null, code, null);
    }

    public Cust getCustByName(String name) {
        return this.getCust(null, null, name);
    }

    private Store getStore(String id, String code, String name) {
        Store obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (storeMap.containsKey(key)) {
            obj = storeMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            obj = this.erpCommonMapper.getStore(id, code, name);
            this.add(id, code, name, null, storeMap, obj, null);
        }
        return obj;
    }

    public Store getStoreById(String id) {
        return this.getStore(id, null, null);
    }

    public Store getStoreByCode(String code) {
        return this.getStore(null, code, null);
    }

    public Store getStoreByName(String name) {
        return this.getStore(null, null, name);
    }

    private Factory getFactory(String id, String code, String name) {
        Factory obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (factoryMap.containsKey(key)) {
            obj = factoryMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            obj = this.erpCommonMapper.getFactory(id, code, name);
            this.add(id, code, name, null, factoryMap, obj, null);
        }
        return obj;
    }

    public Factory getFactoryById(String id) {
        return this.getFactory(id, null, null);
    }

    public Factory getFactoryByCode(String code) {
        return this.getFactory(null, code, null);
    }

    public Factory getFactoryByName(String name) {
        return this.getFactory(null, null, name);
    }

    private Dept getDept(String id, String code, String name) {
        Dept obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (deptMap.containsKey(key)) {
            obj = deptMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            obj = this.erpCommonMapper.getDept(id, code, name);
            this.add(id, code, name, null, deptMap, obj, null);
        }
        return obj;
    }

    public Dept getDeptById(String id) {
        return this.getDept(id, null, null);
    }

    public Dept getDeptByCode(String code) {
        return this.getDept(null, code, null);
    }

    public Dept getDeptByName(String name) {
        return this.getDept(null, null, name);
    }

    private Logistic getLogistic(String id, String code, String name, String outCode) {
        Logistic obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (logisticMap.containsKey(key)) {
            obj = logisticMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)outCode)) {
            obj = this.erpCommonMapper.getLogistic(id, code, name, outCode);
            this.add(id, code, name, outCode, logisticMap, obj, null);
        }
        return obj;
    }

    public Logistic getLogisticById(String id) {
        return this.getLogistic(id, null, null, null);
    }

    public Logistic getLogisticByCode(String code) {
        return this.getLogistic(null, code, null, null);
    }

    public Logistic getLogisticByName(String name) {
        return this.getLogistic(null, null, name, null);
    }

    public Logistic getLogisticByOutCode(String outCode) {
        return this.getLogistic(null, null, null, outCode);
    }

    private MatClass getMatClass(String id, String code, String name) {
        MatClass obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (classMap.containsKey(key)) {
            obj = classMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            obj = this.erpCommonMapper.getMatClass(id, code, name);
            this.add(id, code, name, null, classMap, obj, null);
        }
        return obj;
    }

    public MatClass getMatClassById(String id) {
        return this.getMatClass(id, null, null);
    }

    public MatClass getMatClassByCode(String code) {
        return this.getMatClass(null, code, null);
    }

    public MatClass getMatClassByName(String name) {
        return this.getMatClass(null, null, name);
    }

    private CustClass getCustClass(String id, String code, String name) {
        CustClass obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (custClassMap.containsKey(key)) {
            obj = custClassMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            obj = this.erpCommonMapper.getCustClass(id, code, name);
            this.add(id, code, name, null, custClassMap, obj, null);
        }
        return obj;
    }

    public CustClass getgetCustClassById(String id) {
        return this.getCustClass(id, null, null);
    }

    public CustClass getgetCustClassByCode(String code) {
        return this.getCustClass(null, code, null);
    }

    public CustClass getgetCustClassByName(String name) {
        return this.getCustClass(null, null, name);
    }

    private Supplier getSupplier(String id, String code, String name) {
        Supplier obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (supplierMap.containsKey(key)) {
            obj = supplierMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            obj = this.erpCommonMapper.getSupplier(id, code, name);
            this.add(id, code, name, null, supplierMap, obj, null);
        }
        return obj;
    }

    public Supplier getSupplierById(String id) {
        return this.getSupplier(id, null, null);
    }

    public Supplier getSupplierByCode(String code) {
        return this.getSupplier(null, code, null);
    }

    public Supplier getSupplierByName(String name) {
        return this.getSupplier(null, null, name);
    }

    private Shop getShop(String id, String code, String name, String outCode) {
        Shop obj = null;
        String key = this.getKey(id, code, name, outCode, null);
        if (shopMap.containsKey(key)) {
            obj = shopMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)outCode)) {
            obj = this.erpCommonMapper.getShop(id, code, name, outCode);
            this.add(id, code, name, outCode, shopMap, obj, null);
        }
        return obj;
    }

    public Shop getShopById(String id) {
        return this.getShop(id, null, null, null);
    }

    public Shop getShopByCode(String code) {
        return this.getShop(null, code, null, null);
    }

    public Shop getShopByName(String name) {
        return this.getShop(null, null, name, null);
    }

    public Shop getShopByOutCode(String outCode) {
        return this.getShop(null, null, null, outCode);
    }

    private Emp getEmp(String id, String code, String name) {
        Emp obj = null;
        String key = this.getKey(id, code, name, null, null);
        if (empMap.containsKey(key)) {
            obj = empMap.get(key);
        } else if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            obj = this.erpCommonMapper.getEmp(id, code, name);
            this.add(id, code, name, null, empMap, obj, null);
        }
        return obj;
    }

    public Emp getEmpById(String id) {
        return this.getEmp(id, null, null);
    }

    public Emp getEmpByCode(String code) {
        return this.getEmp(null, code, null);
    }

    public Emp getEmpByName(String name) {
        return this.getEmp(null, null, name);
    }

    public Freshness getFreshness(String customerId, String storeId, String matId) {
        String shelfLifeClass = this.getMatById(matId).getShelfLifeClass();
        if (StringUtils.isNotBlank((CharSequence)shelfLifeClass)) {
            String key = customerId + "|" + storeId + "|" + shelfLifeClass;
            if (freshnessMap.get(key) != null) {
                return MyCopy.copy(freshnessMap.get(key));
            }
            if (StringUtils.isNotBlank((CharSequence)customerId) && StringUtils.isNotBlank((CharSequence)storeId) && StringUtils.isNotBlank((CharSequence)shelfLifeClass)) {
                Freshness find = this.erpCommonMapper.getFreshness(customerId, storeId, shelfLifeClass);
                freshnessMap.put(key, find);
                return find;
            }
        }
        return null;
    }

    private Dict getDict(String parentCode, String id, String code, String name) {
        String key = parentCode + this.getKey(id, code, name, null, null);
        if (dictMap.get(key) != null) {
            return MyCopy.copy(dictMap.get(key));
        }
        if (StringUtils.isNotBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name)) {
            Dict find = this.erpCommonMapper.getDict(parentCode, id, code, name);
            dictMap.put(key, find);
            return find;
        }
        return null;
    }

    public Dict getDictById(String parentCode, String id) {
        return this.getDict(parentCode, id, null, null);
    }

    public Dict getDictByCode(String parentCode, String code) {
        return this.getDict(parentCode, null, code, null);
    }

    public Dict getDictByName(String parentCode, String name) {
        return this.getDict(parentCode, null, null, name);
    }

    public ShopLogistic getShopLogistic(String shopId, String logisticId) {
        String key = shopId + "|" + logisticId;
        if (shopLogisticMap.get(key) != null) {
            return MyCopy.copy(shopLogisticMap.get(key));
        }
        if (StringUtils.isNotBlank((CharSequence)shopId) && StringUtils.isNotBlank((CharSequence)logisticId)) {
            ShopLogistic find = this.erpCommonMapper.getShopLogistic(shopId, logisticId);
            shopLogisticMap.put(key, find);
            return find;
        }
        return null;
    }

    public Packing getPacking(String custId, String matId) {
        String key = custId + "|" + matId;
        if (packingNumMap.get(key) != null) {
            return MyCopy.copy(packingNumMap.get(key));
        }
        if (StringUtils.isNotBlank((CharSequence)custId) && StringUtils.isNotBlank((CharSequence)matId)) {
            Packing find = this.erpCommonMapper.getPacking(custId, matId);
            packingNumMap.put(key, MyCopy.copy(find));
            return find;
        }
        return null;
    }

    private void clear() {
        matMap.clear();
        matListMap.clear();
        custMap.clear();
        custListMap.clear();
        custClassMap.clear();
        storeMap.clear();
        storeListMap.clear();
        factoryMap.clear();
        supplierMap.clear();
        deptMap.clear();
        classMap.clear();
        logisticMap.clear();
        shopMap.clear();
        empMap.clear();
        packingNumMap.clear();
        freshnessMap.clear();
        dictMap.clear();
        shopLogisticMap.clear();
        this.daysToHoursMap.clear();
        this.dateTimeToDateMap.clear();
        suitMap.clear();
        suitListMap.clear();
        this.anchorMap.clear();
    }

    public List<String> getAnchorIds(String plateFrom) {
        if (this.anchorMap.containsKey(plateFrom)) {
            return this.anchorMap.get(plateFrom);
        }
        if (StringUtils.isNotBlank((CharSequence)plateFrom)) {
            List<String> anchorIds = this.erpCommonMapper.getAnchorIds(plateFrom);
            this.anchorMap.put(plateFrom, anchorIds);
            return anchorIds;
        }
        return null;
    }

    public boolean daysToHours(String cargo_master_code) {
        if (this.daysToHoursMap.containsKey(cargo_master_code)) {
            return this.daysToHoursMap.get(cargo_master_code);
        }
        String find = this.erpCommonMapper.wmsDaysToHours(cargo_master_code);
        if (StringUtils.isNotBlank((CharSequence)find)) {
            this.daysToHoursMap.put(cargo_master_code, true);
            return true;
        }
        this.daysToHoursMap.put(cargo_master_code, false);
        return false;
    }

    public boolean dateTimeToDate(String cargo_master_code) {
        if (this.dateTimeToDateMap.containsKey(cargo_master_code)) {
            return this.dateTimeToDateMap.get(cargo_master_code);
        }
        String find = this.erpCommonMapper.wmsdateTimeToDate(cargo_master_code);
        if (StringUtils.isNotBlank((CharSequence)find)) {
            this.dateTimeToDateMap.put(cargo_master_code, true);
            return true;
        }
        this.dateTimeToDateMap.put(cargo_master_code, false);
        return false;
    }

    public void deleteCache(TextMessage message) throws JMSException {
        Cache cache = null;
        try {
            cache = (Cache)JSONObject.parseObject((String)message.getText(), Cache.class);
        }
        catch (Exception e) {
            return;
        }
        if (null == cache || StringUtils.isBlank((CharSequence)cache.getType()) || StringUtils.isBlank((CharSequence)cache.getKey())) {
            return;
        }
        if (cache.getType().equals("Cust")) {
            Cust obj = this.erpCommonMapper.getCust(cache.getKey(), null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, custMap, null);
            }
            packingNumMap.clear();
            freshnessMap.clear();
            custListMap.clear();
        } else if (cache.getType().equals("CustClass")) {
            custClassMap.clear();
            custMap.clear();
        } else if (cache.getType().equals("Dept")) {
            Dept obj = this.erpCommonMapper.getDept(cache.getKey(), null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, deptMap, null);
            }
        } else if (cache.getType().equals("Factory")) {
            Factory obj = this.erpCommonMapper.getFactory(cache.getKey(), null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, factoryMap, null);
            }
        } else if (cache.getType().equals("Logistic")) {
            Logistic obj = this.erpCommonMapper.getLogistic(cache.getKey(), null, null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), logisticMap, null);
            }
            shopLogisticMap.clear();
        } else if (cache.getType().equals("Mat")) {
            Mat obj = this.erpCommonMapper.getMat(cache.getKey(), null, null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getCbarcode(), matMap, null);
            }
            matListMap.clear();
        } else if (cache.getType().equals("MatClass")) {
            MatClass obj = this.erpCommonMapper.getMatClass(cache.getKey(), null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, classMap, null);
            }
        } else if (cache.getType().equals("Shop")) {
            Shop obj = this.erpCommonMapper.getShop(cache.getKey(), null, null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), obj.getOutCode(), shopMap, null);
            }
            this.anchorMap.clear();
        } else if (cache.getType().equals("Store")) {
            Store obj = this.erpCommonMapper.getStore(cache.getKey(), null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, storeMap, null);
            }
            storeListMap.clear();
        } else if (cache.getType().equals("Emp")) {
            Emp obj = this.erpCommonMapper.getEmp(cache.getKey(), null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, empMap, null);
            }
        } else if (cache.getType().equals("Suit")) {
            Suit obj = this.erpCommonMapper.getSuit(cache.getKey(), null, null, null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, suitMap, obj.getShopId());
            }
            suitListMap.clear();
        } else if (cache.getType().equals("Supplier")) {
            Supplier obj = this.erpCommonMapper.getSupplier(cache.getKey(), null, null);
            if (null != obj) {
                this.deleteKey(obj.getCguid(), obj.getCode(), obj.getName(), null, supplierMap, null);
            }
        } else if (cache.getType().equals("Dict")) {
            dictMap.clear();
        } else if (cache.getType().equals("all")) {
            this.clear();
        }
    }

    private String getKey(String id, String code, String name, String outCode, String other) {
        String key = "";
        if (StringUtils.isNotBlank((CharSequence)id)) {
            key = id_ + id;
        } else if (StringUtils.isNotBlank((CharSequence)code)) {
            key = code_ + code + (other == null ? "" : "|" + other);
        } else if (StringUtils.isNotBlank((CharSequence)name)) {
            key = name_ + name + (other == null ? "" : "|" + other);
        } else if (StringUtils.isNotBlank((CharSequence)outCode)) {
            key = outCode_ + outCode + (other == null ? "" : "|" + other);
        }
        return key;
    }

    private <T> void deleteKey(String id, String code, String name, String outCode, Map<String, T> mapL, String other) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            mapL.remove(id_ + id);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            mapL.remove(code_ + code + (other == null ? "" : "|" + other));
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            mapL.remove(name_ + name + (other == null ? "" : "|" + other));
        }
        if (StringUtils.isNotBlank((CharSequence)outCode)) {
            mapL.remove(outCode_ + outCode + (other == null ? "" : "|" + other));
        }
    }

    private <T> void add(String id, String code, String name, String outCode, Map<String, T> mapL, T t, String other) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            mapL.put(id_ + id, t);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            mapL.put(code_ + code + (other == null ? "" : "|" + other), t);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            mapL.put(name_ + name + (other == null ? "" : "|" + other), t);
        }
        if (StringUtils.isNotBlank((CharSequence)outCode)) {
            mapL.put(outCode_ + outCode + (other == null ? "" : "|" + other), t);
        }
    }

    public List<Mat> getMatSearch(String search) {
        String[] key = search.split(",");
        List<String> key_ = Arrays.asList(key);
        Collections.sort(key_);
        search = StringUtils.join(key_, (String)",");
        if (matListMap.get(search) != null) {
            return matListMap.get(search);
        }
        List<Mat> find = null;
        find = key_ != null && key_.size() > 0 ? this.erpCommonMapper.getMatSearch(key_) : this.erpCommonMapper.getMatSearch(null);
        matListMap.put(search, find);
        SqlPrintInterceptor.printLog();
        SqlPrintInterceptor.outLog();
        return find;
    }

    public List<Suit> getSuitSearch(String search) {
        String[] key = search.split(",");
        List<String> key_ = Arrays.asList(key);
        Collections.sort(key_);
        search = StringUtils.join(key_, (String)",");
        if (suitListMap.get(search) != null) {
            return suitListMap.get(search);
        }
        List<Suit> find = null;
        find = key_ != null && key_.size() > 0 ? this.erpCommonMapper.getSuitSearch(key_) : this.erpCommonMapper.getSuitSearch(null);
        if (null != find && !find.isEmpty()) {
            for (Suit v : find) {
                Shop s = this.getShopById(v.getShopId());
                if (null == s) continue;
                v.setShopName(s.getName());
            }
        }
        SqlPrintInterceptor.printLog();
        SqlPrintInterceptor.outLog();
        suitListMap.put(search, find);
        return find;
    }

    public List<Cust> getCustSearch(String search) {
        String[] key = search.split(",");
        List<String> key_ = Arrays.asList(key);
        Collections.sort(key_);
        search = StringUtils.join(key_, (String)",");
        if (custListMap.get(search) != null) {
            return custListMap.get(search);
        }
        List<Cust> find = null;
        find = key_ != null && key_.size() > 0 ? this.erpCommonMapper.getCustSearch(key_) : this.erpCommonMapper.getCustSearch(null);
        SqlPrintInterceptor.printLog();
        SqlPrintInterceptor.outLog();
        custListMap.put(search, find);
        return find;
    }

    public List<Store> getStoreSearch(String search) {
        String[] key = search.split(",");
        List<String> key_ = Arrays.asList(key);
        Collections.sort(key_);
        search = StringUtils.join(key_, (String)",");
        if (storeListMap.get(search) != null) {
            return storeListMap.get(search);
        }
        List<Store> find = null;
        find = key_ != null && key_.size() > 0 ? this.erpCommonMapper.getStoreSearch(key_) : this.erpCommonMapper.getStoreSearch(null);
        SqlPrintInterceptor.printLog();
        SqlPrintInterceptor.outLog();
        storeListMap.put(search, find);
        return find;
    }

    public void saveDispatchOrderAccountDetails(String mainId, String storeId) {
        this.erpCommonMapper.saveDispatchOrderAccountDetails(mainId, storeId, "\u53d1\u8d27\u5355", "0");
    }

    public void saveStoreOrderAccountDetails(String mainId, String storeId, String billType, Integer inOuttype) {
        this.erpCommonMapper.saveStoreOrderAccountDetails(mainId, storeId, billType, inOuttype + "");
    }

    public void savePuStoreOrderAccountDetails(String mainId, String storeId) {
        this.erpCommonMapper.savePuStoreOrderAccountDetails(mainId, storeId, "\u91c7\u8d2d\u5165\u5e93\u5355", "1");
    }

    public void updateShopToken(String id, String shopToken) {
        this.erpCommonMapper.updateShopToken(id, shopToken);
        ((CacheMainDel)SpringGetBeanUtil.getBean(CacheMainDel.class)).sendDelete(Shop.delteCache(id));
    }
}

