/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common.domain;

import cc.lechun.erp.config.imp.CacheMainDel;
import cc.lechun.erp.dao.common.ErpOperationDataMapper;
import cc.lechun.erp.domain.batch.MatchTheBatchDo;
import cc.lechun.erp.domain.batch.entity.CanUseFiled;
import cc.lechun.erp.domain.batch.entity.CanUseQty;
import cc.lechun.erp.domain.batch.entity.batch.MatchBatch;
import cc.lechun.erp.domain.common.domain.MatDo;
import cc.lechun.erp.domain.common.domain.StoreDo;
import cc.lechun.erp.domain.common.entity.Shop;
import cc.lechun.erp.util.method.AtoB;
import cc.lechun.erp.util.method.Error_;
import cc.lechun.erp.util.method.Method;
import cc.lechun.erp.util.method.No_;
import cc.lechun.erp.util.method.Ok_;
import cc.lechun.erp.util.method.Operation;
import cc.lechun.erp.util.method.Success_;
import cc.lechun.erp.util.method.ToCanUseFiled;
import cc.lechun.erp.util.redisLock.ErpRedisReturnLock;
import cc.lechun.framework.common.utils.SpringUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationDataDo
implements Serializable {
    private static Logger log = LoggerFactory.getLogger((String)"OperationDataDo");

    public static String getCanUseKey(String storeId, String matId, Date productionDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(matId).append("|");
        sb.append(storeId);
        if (null != productionDate) {
            sb.append("|").append(DateUtils.formatDate((Date)productionDate, (String)"yyyyMMdd"));
        }
        return sb.toString();
    }

    public static <T> MatchBatch matchingBatchs(T t, AtoB<T, MatchBatch> atob, Ok_<MatchBatch> ok_, No_<MatchBatch> no_) {
        if (null == t) {
            MatchBatch l = new MatchBatch();
            l.setStatus(500);
            l.setErroMessage("\u53c2\u6570\u9519\u8bef \u672a\u67e5\u8be2\u5230\u8981\u8f6c\u6362\u7684\u6570\u636e");
            return l;
        }
        MatchBatch l = atob.aToB(t);
        return ((ErpRedisReturnLock)SpringUtil.getBean(ErpRedisReturnLock.class)).myLock(l.getStoreId(), () -> {
            MatchBatch s = ((MatchTheBatchDo)SpringUtil.getBean(MatchTheBatchDo.class)).matcBatchByOrder(l);
            if (s.getStatus() != 200) {
                no_.no(s);
            } else {
                ok_.ok(s);
            }
            return s;
        });
    }

    public static <M> BaseJsonVo<String> getCanUseBatchs(String storeId, Object notInOrderType, List<M> oldList, ToCanUseFiled<M> toCanUseFiled) {
        return ((ErpRedisReturnLock)SpringUtil.getBean(ErpRedisReturnLock.class)).myLock(storeId, () -> {
            BaseJsonVo<String> baseJsonVo = OperationDataDo.getCanUseQtys(storeId, toCanUseFiled.toCanUseFiled(oldList), notInOrderType);
            return baseJsonVo;
        });
    }

    public static <M> BaseJsonVo<String> checkCanUseQtys(String storeId, Object notInOrderType, List<M> oldList, ToCanUseFiled<M> toCanUseFiled) {
        return ((ErpRedisReturnLock)SpringUtil.getBean(ErpRedisReturnLock.class)).myLock(storeId, () -> {
            BaseJsonVo<String> baseJsonVo = OperationDataDo.getCanUseQtys(storeId, toCanUseFiled.toCanUseFiled(oldList), notInOrderType);
            return baseJsonVo;
        });
    }

    public static <M> BaseJsonVo<String> checkCanUseQtys(String storeId, Object notInOrderType, List<M> oldList, ToCanUseFiled<M> toCanUseFiled, Operation operation) {
        return ((ErpRedisReturnLock)SpringUtil.getBean(ErpRedisReturnLock.class)).myLock(storeId, () -> {
            BaseJsonVo<String> baseJsonVo = OperationDataDo.getCanUseQtys(storeId, toCanUseFiled.toCanUseFiled(oldList), notInOrderType);
            operation.operation(baseJsonVo);
            return baseJsonVo;
        });
    }

    public static <M> BaseJsonVo<String> checkCanUseQtys(String storeId, Object notInOrderType, List<M> oldList, ToCanUseFiled<M> toCanUseFiled, Success_ success_, Error_ error_) {
        return ((ErpRedisReturnLock)SpringUtil.getBean(ErpRedisReturnLock.class)).myLock(storeId, () -> {
            BaseJsonVo<String> baseJsonVo = OperationDataDo.getCanUseQtys(storeId, toCanUseFiled.toCanUseFiled(oldList), notInOrderType);
            if (baseJsonVo.getStatus() == 200) {
                success_.success();
            } else {
                error_.error(baseJsonVo.getError_msg());
            }
            return baseJsonVo;
        });
    }

    private static BaseJsonVo<String> getCanUseQtys(String storeId, List<CanUseFiled> mats, Object notInOrderType) {
        Set matIds = mats.stream().map(v -> v.getMatId()).collect(Collectors.toSet());
        List<CanUseQty> list = OperationDataDo.getCanUseQty(storeId, matIds, notInOrderType);
        Map canUseMap = list.stream().collect(Collectors.toMap(m -> m.getOneKey(), Function.identity(), (k1, k2) -> k1));
        Map<String, List<CanUseFiled>> mapGroup = mats.stream().collect(Collectors.groupingBy(s -> OperationDataDo.getCanUseKey(storeId, s.getMatId(), s.getProductionDate())));
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, List<CanUseFiled>> group : mapGroup.entrySet()) {
            BigDecimal matNumSum = group.getValue().stream().map(v -> v.getMatNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (canUseMap.containsKey(group.getKey())) {
                BigDecimal diff = matNumSum.subtract(((CanUseQty)canUseMap.get(group.getKey())).getCanUseQty());
                if (!(diff.doubleValue() > 0.0)) continue;
                sb.append("\u7269\u54c1(" + MatDo.id(group.getValue().get(0).getMatId()).getName());
                if (null != group.getValue().get(0).getProductionDate()) {
                    sb.append("- \u6279\u6b21 :").append(DateUtils.formatDate((Date)group.getValue().get(0).getProductionDate(), (String)"yyyyMMdd"));
                }
                sb.append(")\u53f0\u8d26\u5dee(" + diff.doubleValue() + ")\u4e2a").append("\u3002");
                continue;
            }
            sb.append("\u7269\u54c1(" + MatDo.id(group.getValue().get(0).getMatId()).getName());
            if (null != group.getValue().get(0).getProductionDate()) {
                sb.append("- \u6279\u6b21 :").append(DateUtils.formatDate((Date)group.getValue().get(0).getProductionDate(), (String)"yyyyMMdd"));
            }
            sb.append(") \u53f0\u8d26\u5dee(" + matNumSum.doubleValue() + ")\u4e2a").append("\u3002");
        }
        if (!sb.toString().equals("")) {
            return BaseJsonVo.error((String)("\u4ed3\u5e93(" + StoreDo.id(storeId).getName() + ")" + sb.toString()));
        }
        return BaseJsonVo.success((Object)"");
    }

    private static List<CanUseQty> getCanUseQty(Object storeIds, Object matIds, Object notInOrderType) {
        return Method.getBean(ErpOperationDataMapper.class).getCanUseQty(storeIds, matIds, notInOrderType);
    }

    public static void updateShopToken(String id, String shopToken) {
        Method.getBean(ErpOperationDataMapper.class).updateShopToken(id, shopToken);
        CacheMainDel.delete(Shop.delteCache("all"));
    }

    public static void saveDispatchOrderAccountDetails(String mainId, String storeId) {
        Method.getBean(ErpOperationDataMapper.class).saveDispatchOrderAccountDetails(mainId, storeId, "\u53d1\u8d27\u5355", "0");
    }

    public static void saveStoreOrderAccountDetails(String mainId, String storeId, String billType, String inOuttype) {
        Method.getBean(ErpOperationDataMapper.class).saveStoreOrderAccountDetails(mainId, storeId, billType, inOuttype);
    }

    public static void savePuStoreOrderAccountDetails(String mainId, String storeId) {
        Method.getBean(ErpOperationDataMapper.class).savePuStoreOrderAccountDetails(mainId, storeId, "\u91c7\u8d2d\u5165\u5e93\u5355", "1");
    }
}

