/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.util.otherHttp;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHttp {
    private static Logger log = LoggerFactory.getLogger(ClientHttp.class);

    public static String post(String urlMethod, LinkedHashMap<String, String> paramsUrl, JSONObject paramsBody) {
        String url = urlMethod + "?" + ClientHttp.paramToUrl(paramsUrl);
        String body = JSONObject.toJSONString((Object)paramsBody);
        log.info("POST\u8bf7\u6c42\u5730\u5740 : " + url);
        log.info("POST\u8bf7\u6c42\u53c2\u6570 : " + body);
        String result = ClientHttp.getRequstData(url, body, "POST");
        return result;
    }

    private static String paramToUrl(LinkedHashMap<String, String> paramsUrl) {
        StringBuffer paramStr = new StringBuffer();
        if (paramsUrl != null && paramsUrl.size() > 0) {
            for (Map.Entry<String, String> param : paramsUrl.entrySet()) {
                try {
                    paramStr.append(param.getKey() + "=" + URLEncoder.encode(param.getValue(), "UTF-8") + "&");
                }
                catch (Exception exception) {}
            }
        }
        return paramStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRequstData(String urlNew, String params, String getType) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlNew);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod(getType);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.connect();
            if (getType.equals("POST") && StringUtils.isNotBlank((CharSequence)params)) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
                writer.write(params);
                writer.close();
            }
            int responseCode = connection.getResponseCode();
            StringBuilder builder = new StringBuilder();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                builder.setLength(0);
                String line = "";
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                reader.close();
                String string = builder.toString();
                return string;
            }
            log.error("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38 responseCode \u5f02\u5e38\u4fe1\u606f:<{}> ", (Object)responseCode);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38 url <{}> \u53c2\u6570 <{}> \u5f02\u5e38\u4fe1\u606f:<{}> ", new Object[]{urlNew, params, e});
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }
}

