/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.config.artemis;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class JmsQueue {
    @Bean(name={"listenerQueueFactory"})
    public JmsListenerContainerFactory<?> listenerQueueFactory(ActiveMQConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory((ConnectionFactory)connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(false));
        factory.setDestinationResolver(new DestinationResolver(this){

            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                return session.createQueue(destinationName);
            }
        });
        return factory;
    }

    @Bean(name={"jmsTemplateQueue"})
    public static JmsTemplate jmsTemplateArtemis(@Qualifier(value="factory_") ConnectionFactory connectionFactory) {
        JmsTemplate template = new JmsTemplate(connectionFactory);
        template.setPubSubDomain(false);
        return template;
    }
}

