/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.util;

import cc.lechun.erp.util.MyDateUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class OrderIdUtils {
    private long lastTimestamp = -1L;
    private final String machineId;
    private static AtomicInteger sequence = new AtomicInteger(0);
    private static String myid = OrderIdUtils.getIpAddressCode();
    private static OrderIdUtils instance = new OrderIdUtils(myid);

    public OrderIdUtils(String machineId) {
        this.machineId = machineId;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public synchronized String nextId() {
        Date now = new Date();
        String time = MyDateUtil.formatDate(now, "yyyyMMddHHmmss");
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new IllegalStateException("Clock moved backwards.");
        }
        int flag = sequence.incrementAndGet();
        sequence.set(flag % 10000);
        StringBuilder sb = new StringBuilder(time).append(this.machineId).append(this.leftPad(flag, 5));
        this.lastTimestamp = timestamp;
        return sb.toString();
    }

    private String leftPad(long i, int n) {
        String s = String.valueOf(i);
        StringBuilder sb = new StringBuilder();
        int c = n - s.length();
        c = c < 0 ? 0 : c;
        for (int t = 0; t < c; ++t) {
            sb.append("0");
        }
        return sb.append(s).toString();
    }

    public static OrderIdUtils getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        System.out.println(OrderIdUtils.getIpAddressCode());
    }

    private static String getIpAddressCode() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            Object str = addr.getHostAddress().split("[.]")[3];
            if (((String)str).length() == 1) {
                str = "00" + (String)str;
            } else if (((String)str).length() == 2) {
                str = "0" + (String)str;
            }
            return str;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "01";
        }
    }

    public static String getOrderNumber() {
        OrderIdUtils orderId = OrderIdUtils.getInstance();
        String nextId = orderId.nextId();
        return nextId;
    }
}

