/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.cache;

import cc.lechun.erp.util.Redis;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service
public class RedisCacheUtil<T> {
    public void removePattern(String pattern) {
        try {
            Set keys = Redis.redis().keys((Object)pattern);
            if (keys.size() > 0) {
                Redis.redis().delete((Collection)keys);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(String key) {
        try {
            if (this.exists(key)) {
                Redis.redis().delete((Object)key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean exists(String key) {
        return Redis.redis().hasKey((Object)key);
    }

    public Object get(String key) {
        Object result = null;
        ValueOperations operations = Redis.redis().opsForValue();
        result = operations.get((Object)key);
        return result;
    }

    public boolean set(String key, Object value) {
        return this.set(key, value, 60L);
    }

    public boolean set(String key, Object value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = Redis.redis().opsForValue();
            operations.set((Object)key, value);
            if (expireTime != 0L) {
                Redis.redis().expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

