/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.core.baseclass;

import cc.lechun.framework.core.baseclass.DbContextHolder;
import cc.lechun.framework.core.baseclass.DbType;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration
public class DataSourceConfig {
    @Bean(name={"writeDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.primary")
    public DruidDataSource writeDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean(name={"readDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.secondary")
    public DruidDataSource readDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Primary
    @Bean(name={"dynamicDataSource"})
    public DataSource dynamicDataSource(@Qualifier(value="writeDataSource") DruidDataSource writeDataSource, @Qualifier(value="readDataSource") DruidDataSource readDataSource) {
        HashMap<DbType, DruidDataSource> targetDataSources = new HashMap<DbType, DruidDataSource>();
        targetDataSources.put(DbType.WRITE, writeDataSource);
        targetDataSources.put(DbType.READ, readDataSource);
        AbstractRoutingDataSource routingDataSource = new AbstractRoutingDataSource(){

            protected Object determineCurrentLookupKey() {
                return DbContextHolder.getDbType();
            }
        };
        routingDataSource.setDefaultTargetDataSource((Object)writeDataSource);
        routingDataSource.setTargetDataSources(targetDataSources);
        return routingDataSource;
    }
}

