/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.util.otherHttp;

import cc.lechun.erp.util.GetBean;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class XiaoKeHttp {
    private static Logger log = LoggerFactory.getLogger(XiaoKeHttp.class);
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Value(value="${xiaoke.appId:1}")
    private String appId;
    @Value(value="${xiaoke.appSecret:1}")
    private String appSecret;
    @Value(value="${xiaoke.permanentCode:1}")
    private String permanentCode;
    @Value(value="${xiaoke.currentOpenUserId:1}")
    private String currentOpenUserId;
    private String redistokenKey = "xiaoke_token_key";
    private String openUserIdIdKey = "xiaoke_openUserIdIdKey_key";

    public static JSONObject openXiaoKeApi(String url, JSONObject paramsBody) {
        return GetBean.getBean(XiaoKeHttp.class).xiaoKeApi(url, paramsBody);
    }

    public JSONObject xiaoKeApi(String url, JSONObject paramsBody) {
        long a = System.currentTimeMillis();
        log.info("\u9500\u5ba2\u64cd\u4f5c \u5f00\u59cb ======================================================================  \u300b\u300b \n");
        log.info("\u53c2\u6570 rul \uff1a{} ======\u53c2\u6570 \uff1a{}", (Object)url, (Object)JSONObject.toJSONString((Object)paramsBody, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        this.buildTokenAndCorpId(paramsBody);
        JSONObject result = this.operationByPost(url, paramsBody);
        if (this.chekResult(result, paramsBody)) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (Exception e) {
                log.error("\u9500\u5ba2\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        long b = System.currentTimeMillis();
        log.info("\u9500\u5ba2\u64cd\u4f5c \u7ed3\u675f ======================================================================= \u300b\u300b \u8017\u65f6" + (double)(b - a) / 1000.0 + " \n");
        return result;
    }

    private JSONObject operationByPost(String url, JSONObject paramsBody) {
        StringBuffer sb = new StringBuffer();
        String body = JSONObject.toJSONString((Object)paramsBody, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        sb.append("\n");
        sb.append("POST\u8bf7\u6c42\u5730\u5740 : " + url).append("\n");
        sb.append("POST\u8bf7\u6c42\u53c2\u6570 : " + body).append("\n");
        String result = this.getRequstData(url, body, "POST");
        sb.append("\u8fd4\u56de\u6570\u636e : " + result).append("\n");
        log.info(sb.toString());
        return (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequstData(String urlNew, String params, String getType) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlNew);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod(getType);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.connect();
            if (getType.equals("POST") && StringUtils.isNotBlank((CharSequence)params)) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
                writer.write(params);
                writer.close();
            }
            int responseCode = connection.getResponseCode();
            StringBuilder builder = new StringBuilder();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                builder.setLength(0);
                String line = "";
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                reader.close();
                String string = builder.toString();
                return string;
            }
            log.error("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38 responseCode \u5f02\u5e38\u4fe1\u606f:<{}> ", (Object)responseCode);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38 url <{}> \u53c2\u6570 <{}> \u5f02\u5e38\u4fe1\u606f:<{}> ", new Object[]{urlNew, params, e});
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    private boolean chekResult(JSONObject result, JSONObject paramsBody) {
        if (result.get("errorMessage").toString().equals("corpAccessToken error") || Integer.valueOf(result.get("errorCode").toString()) == 20016 || Integer.valueOf(result.get("errorCode").toString()) == 20038) {
            JSONObject json = this.getTokenAndCorpId();
            if (Integer.valueOf(json.get("errorCode").toString()) != 0) {
                return false;
            }
            this.setTokenAndCorpId(json);
            return true;
        }
        if (result.get("errorMessage").toString().equals("the openUserId must start") || Integer.valueOf(result.get("errorCode").toString()) == 10006) {
            this.getOpenUserIdId(true);
            return true;
        }
        return false;
    }

    private JSONObject getTokenAndCorpId() {
        JSONObject paramsToken = new JSONObject();
        paramsToken.put((Object)"appId", (Object)this.appId);
        paramsToken.put((Object)"appSecret", (Object)this.appSecret);
        paramsToken.put((Object)"permanentCode", (Object)this.permanentCode);
        JSONObject resultNewq = this.operationByPost("https://open.fxiaoke.com/cgi/corpAccessToken/get/V2", paramsToken);
        return resultNewq;
    }

    private String getOpenUserIdId(boolean flag) {
        Object obj = this.redisCacheUtil.get(this.openUserIdIdKey);
        String openUserIdIdKey = null;
        if (obj == null || flag || ((String)obj).equals("null")) {
            JSONObject tokenRdis = (JSONObject)this.redisCacheUtil.get(this.redistokenKey);
            if (tokenRdis != null) {
                JSONObject paramsToken = new JSONObject();
                paramsToken.put((Object)"corpAccessToken", tokenRdis.get("corpAccessToken"));
                paramsToken.put((Object)"corpId", tokenRdis.get("corpId"));
                paramsToken.put((Object)"mobile", (Object)this.currentOpenUserId);
                JSONObject resultNewq = this.operationByPost("https://open.fxiaoke.com/cgi/user/getByMobile", paramsToken);
                if (Integer.valueOf(resultNewq.get("errorCode").toString()) == 0) {
                    JSONArray dataListF = (JSONArray)resultNewq.get("empList");
                    openUserIdIdKey = ((JSONObject)dataListF.get(0)).get("openUserId").toString();
                }
                this.redisCacheUtil.set(this.openUserIdIdKey, openUserIdIdKey, 0x6DDD00L);
            }
        } else {
            openUserIdIdKey = (String)obj;
        }
        return openUserIdIdKey;
    }

    private void buildTokenAndCorpId(JSONObject token) {
        JSONObject tokenRdis = (JSONObject)this.redisCacheUtil.get(this.redistokenKey);
        if (null != tokenRdis) {
            token.put((Object)"currentOpenUserId", (Object)this.getOpenUserIdId(false));
            token.put((Object)"corpAccessToken", tokenRdis.get("corpAccessToken"));
            token.put((Object)"corpId", tokenRdis.get("corpId"));
        } else {
            JSONObject json = this.getTokenAndCorpId();
            if (Integer.valueOf(json.get("errorCode").toString()) == 0) {
                token.put((Object)"corpAccessToken", json.get("corpAccessToken"));
                token.put((Object)"corpId", json.get("corpId"));
                this.setTokenAndCorpId(token);
                token.put((Object)"currentOpenUserId", (Object)this.getOpenUserIdId(false));
            }
        }
    }

    private void setTokenAndCorpId(JSONObject token) {
        this.redisCacheUtil.set(this.redistokenKey, token, 0x6DDD00L);
    }

    public String getUserIdByMobleFromXiaoke(String url, String fileName, String fileValue) {
        return GetBean.getBean(XiaoKeHttp.class).getUserIdByMobleFromXiaoke(url, fileName, fileValue);
    }

    public String getUserIdByMoble(String url, String fileName, String fileValue) {
        long a = System.currentTimeMillis();
        log.info("\u9500\u5ba2\u64cd\u4f5c \u5f00\u59cb ======================================================================  \u300b\u300b \n");
        log.info("\u53c2\u6570 rul \uff1a{} ======fileName \uff1a{}======fileValue \uff1a{}", new Object[]{url, fileName, fileValue});
        String openUserIdIdKey = null;
        JSONObject tokenRdis = (JSONObject)this.redisCacheUtil.get(this.redistokenKey);
        if (null != tokenRdis) {
            JSONObject paramsToken = new JSONObject();
            paramsToken.put((Object)"corpAccessToken", tokenRdis.get("corpAccessToken"));
            paramsToken.put((Object)"corpId", tokenRdis.get("corpId"));
            paramsToken.put((Object)fileName, (Object)fileValue);
            JSONObject resultNewq = this.operationByPost(url, paramsToken);
            if (Integer.valueOf(resultNewq.get("errorCode").toString()) == 0) {
                JSONArray dataListF = (JSONArray)resultNewq.get("empList");
                openUserIdIdKey = ((JSONObject)dataListF.get(0)).get("openUserId").toString();
            }
            this.chekResult(resultNewq, null);
        } else {
            JSONObject token = new JSONObject();
            JSONObject json = this.getTokenAndCorpId();
            if (Integer.valueOf(json.get("errorCode").toString()) == 0) {
                token.put((Object)"corpAccessToken", json.get("corpAccessToken"));
                token.put((Object)"corpId", json.get("corpId"));
                this.setTokenAndCorpId(token);
            }
        }
        long b = System.currentTimeMillis();
        log.info("\u9500\u5ba2\u64cd\u4f5c \u7ed3\u675f ======================================================================= \u300b\u300b \u8017\u65f6" + (double)(b - a) / 1000.0 + " \n");
        return openUserIdIdKey;
    }
}

