/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.eureka;

import cc.lechun.framework.common.eureka.SpringUtil;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EurekaStatusConfig {
    @Autowired
    private ApplicationInfoManager applicationInfoManager;
    @Autowired
    private EurekaClient client;

    @RequestMapping(value={"eurekaChangeStatus"})
    public String change(String status) {
        if (status == null || status.isEmpty()) {
            return "\u8bf7\u8f93\u5165\u72b6\u6001,\u652f\u6301\uff1adown\uff0cup";
        }
        if ("down".equals(status.toLowerCase())) {
            this.client.shutdown();
            this.refresh();
        } else {
            InstanceInfo.InstanceStatus instanceStatus = InstanceInfo.InstanceStatus.toEnum((String)status.toUpperCase());
            this.applicationInfoManager.getInfo().setStatus(instanceStatus);
        }
        return "\u670d\u52a1\u5df2\u7ecf" + status + "!";
    }

    public void refresh() {
        try {
            Method method = DiscoveryClient.class.getDeclaredMethod("refreshRegistry", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)SpringUtil.getBean(DiscoveryClient.class), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

