package cc.lechun.framework.common.enums.sales;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/5/23
 * Description:
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum FreeRuleTypeEnum {

    amount_type(1, "满指定金额"),
    product_type(2, "指定商品"),
    //city_type(3, "城市"),
    vip_type(4, "会员权益");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<FreeRuleTypeEnum> getList() {
        return Arrays.asList(FreeRuleTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        FreeRuleTypeEnum[] ls = FreeRuleTypeEnum.values();
        for (FreeRuleTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    FreeRuleTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
