package cc.lechun.framework.common.utils.date;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by wangxs on 2017/12/11
 * Description: 时间工具类
 */
public class DateUtils {

    private final static Logger log = LoggerFactory.getLogger(DateUtils.class);

    /**
     * 获取当前时间
     */
    public static String now(String format) {
        if (StringUtils.isEmpty(format)) format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(new Date());
    }
    /**
     * 获取当前日期
     */
    public static String date() {
        String format = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(new Date());
    }
    /**
     * 获取当前日期
     */
    public static Date currentDate() {
        String format = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(format);
        String d= f.format(new Date());
        return getDateFromString(d,format);
    }
    /**
     * 获取当前时间
     */
    public static Date now() {
        return new Date();
    }

    /**
     * 获取当前时间的毫秒数
     */
    public static long nowMillis() {
        return System.currentTimeMillis();
    }

    /**
     * 字符串转换成日期
     */
    public static Date StrToDate(String str) {
        Date result=StrToDate(str,"yyyy-MM-dd HH:mm:ss");
        if(result==null){
            return StrToDate(str,"yyyy-MM-dd");
        }
        return result;
    }
    /**
     * 字符串转换成日期
     */
    public static Date StrToDate(String str, String fm) {
        if (StringUtils.isEmpty(fm)) fm = "yyyy-MM-dd HH:mm:ss";
        if (str != null) {
            SimpleDateFormat format = new SimpleDateFormat(fm);
            Date date = null;
            try {
                date = format.parse(str);
            } catch (ParseException e) {
                //log.error("", e);
            }
            return date;
        } else {
            return null;
        }
    }

    /**
     * 定时任务 日期时间转con格式
     */
    public static String taskDateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("s m H d M ? yyyy");
        Date now = new Date();
        String cron = null;
        if (now.getTime() > date.getTime()) {
            cron = sdf.format(new Date(now.getTime() + 5000));
        } else {
            cron = sdf.format(date);
        }
        return cron;
    }
    /**
     * 格式化日期
     * */
    public static String formatDate(Date sourceDate, String format){
        if(sourceDate==null){
            return "";
        }
        if(format.isEmpty())
            format="yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat=new SimpleDateFormat(format);
        Calendar calendar = Calendar.getInstance();//创建一个实例
        calendar.setTime(sourceDate);//实例化一个Calendar。 年、月、日、时、分、秒
        return dateFormat.format(calendar.getTime());
    }
    /**
     * 得到指定日期加上指定类型的时间
     * */
    public static Date getAddDate(Date sourceDate,int type,int count){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(type,count);
        return calendar.getTime();
    }
    /**
     * 得到指定日期加上指定天数的日期
     * */
    public static Date getAddDateByDay(Date sourceDate,int day){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(Calendar.DATE,day);
        return calendar.getTime();
    }
    /**
     * 得到指定日期加上指定秒数的日期
     * */
    public static Date getAddDateBySecond(Date sourceDate,int second){
        Calendar calendar = Calendar.getInstance();//创建一个实例
        calendar.setTime(sourceDate);//实例化一个Calendar。 年、月、日、时、分、秒
        calendar.add(Calendar.SECOND,second);//给当前日期加上指定天数，这里加的是秒
        return calendar.getTime();
    }
    /**
     * 得到指定日期加上指定秒数的日期
     * */
    public static String getAddDateBySecond(Date sourceDate,int second,String format){
        if(format.isEmpty())
            format="yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat=new SimpleDateFormat(format);
        return dateFormat.format(getAddDateBySecond(sourceDate,second));
    }
    public static Date getDateFromString(String k, String dateformat) {

        if(dateformat.isEmpty())
            dateformat="yyyy-MM-dd HH:mm:ss";
        try {
            SimpleDateFormat format=new SimpleDateFormat(dateformat);
            format.setLenient(false);
            return format.parse(k);
        } catch (ParseException e) {
            return null;
        }
    }

    public static Date getDateFromString(String k) {
        Date s= getDateFromString(k,"yyyy-MM-dd HH:mm:ss");
        if(s==null){
           return getDateFromString(k,"yyyy-MM-dd");
        }
        return s;
    }

    public static boolean checkDate(String k,String dateformat) {

        return getDateFromString(k,dateformat)==null?false:true;
    }
    /**
     * 日期时间比较
     * @param sdate
     * @param edate
     * @return =0两个相等，>0表示开始日期小于结束日期，<0表示开始日期大于结束日期
     */
    public static long dateTimeCompare(String sdate,String edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin_date;
            Date end_date;
            begin_date = format.parse(sdate);
            end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime())
                    /1000;
        } catch (Exception e) {
            return -1;
        }
        return day;
    }
    /**
     * 日期比较
     * @param sdate
     * @param edate
     * @return =0两个相等，>0表示开始日期小于结束日期，<0表示开始日期大于结束日期
     */
    public static long dateCompare(String sdate,String edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin_date;
            Date end_date;
            begin_date = format.parse(sdate);
            end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime())/(24 * 60 * 60 * 1000);
        } catch (Exception e) {
            return -1;
        }
        return day;
    }
    /**
     * 日期比较
     * @param sdate
     * @param edate
     * @return =0两个相等，>0表示开始日期小于结束日期，<0表示开始日期大于结束日期
     */
    public static long dateTimeCompare(Date sdate,Date edate) {
        long day = (edate.getTime() - sdate.getTime()) /1000;
        return day;
    }
    public static long getDateDiffSecond(String sdate,String edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin_date;
            Date end_date;
            begin_date = format.parse(sdate);
            end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime())
                    /1000;
        } catch (Exception e) {
            return -1;
        }
        return day;
    }
    public static long getDateDiffSecond(Date sdate,Date edate) {
        long day = 0;
        try {
            day = (edate.getTime() - sdate.getTime())
                    /1000;
        } catch (Exception e) {
            return -1;
        }
        return day;
    }
    /** * 获取指定日期是星期几

     * 参数为null时表示获取当前日期是星期几

     * @param date

     * @return

     */
    public static String getWeekOfDate(Date date) {

        String[] weekOfDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};

        Calendar calendar = Calendar.getInstance();

        if(date != null){

            calendar.setTime(date);

        }

        int w = calendar.get(Calendar.DAY_OF_WEEK) - 1;

        if (w < 0){

            w = 0;

        }
        return weekOfDays[w];
    }
    public static int getWeekIndexOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        if(date != null){
            calendar.setTime(date);
        }
        int w = calendar.get(Calendar.DAY_OF_WEEK)-1;
        if (w < 0){
            w = 0;
        }
        return w==0?7:w;
    }
    public static String getWeekOfDate(int weekIndex) {

        String[] weekOfDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
        if(weekIndex>=0&&weekIndex<=6) {
            return weekOfDays[weekIndex];
        }
        return "";
    }
    public static String getShortWeekOfDate(int weekIndex){
        String s=getWeekOfDate(weekIndex);
        return s.replace("星期","周");
    }
    public static String getShortWeekOfDate(Date date){
        String s=getWeekOfDate(date);
        return s.replace("星期","周");
    }
    /**
     * 格式化日期为中文格式
     * @param SourceDate
     * @param format
     * @return
     */
    public static String formatDateChina(String SourceDate, String format){
        Date d= new Date(dateToTimestamp(SourceDate) * 1000);
        if(format.isEmpty())
            format="MM月dd日";
        SimpleDateFormat dateFormat=new SimpleDateFormat(format);
        Calendar calendar = Calendar.getInstance();//创建一个实例
        calendar.setTime(d);//实例化一个Calendar。 年、月、日、时、分、秒
        return dateFormat.format(calendar.getTime());
    }
    public static long dateToTimestamp(String dateString)  {
        return dateToTimestamp(dateString,"yyyy-MM-dd HH:mm:ss");
    }
    public static long dateToTimestamp(String dateString,String format)  {
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            Date date;
            try {
                date = df.parse(dateString);
            }catch (ParseException e){
                df = new SimpleDateFormat("yyyy-MM-dd");
                date = df.parse(dateString);
            }
            long s = date.getTime();
            return (s / 1000);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return 0;
    }
    public static String getDateName(String date){
        if(date==null||date.isEmpty()){
            return "7日后";
        }
        //String[] s = new String[]{"今日","明日","后日","三日","四日","五日","六日","七日","八日","九日","十日后"};
        int l=(int)DateUtils.getDateDiff(DateUtils.date(),date);
        if(l==0){
            return "今日";
        }
        if(l==1){
            return "明日";
        }
        if(l==2){
            return "后日";
        }

        return formatDateChina(date,"M月d日");

    }
    public static long getDateDiff(String sdate,String edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin_date;
            Date end_date;
            begin_date = format.parse(sdate);
            end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime())
                    / (24 * 60 * 60 * 1000);
        } catch (Exception e) {
            return -1;
        }
        return day;
    }

    public static long getDateDiff(Date sdate,Date edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String startDate = format.format(sdate);
            String endDate = format.format(edate);
            return getDateDiff(startDate,endDate);
        } catch (Exception e) {
            return -1;
        }
    }
}
