package cc.lechun.framework.common.utils.jqgridData;/**
 * Created by lenovo
 *
 * @date 2018/8/1613:20
 */

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Version;

import java.util.List;

/**
 *@ClassNameJqGridData
 *@Description TODO
 *@Author
 *@Date
 *@Version 1.0
 **/
public class JqGridData<T> {

        //current page of the query
        private String page ;

        //total pages for the query
        private String total ;

        //total number of records for the query
        private String records ;

        //an array that contains the actual data
        private List<T> rows ;

        public JqGridData() {
        }

        public JqGridData(List<T> rows) {
            if (rows instanceof Page) {
                //不强制使用分页插件
//            throw new RuntimeException("调用该构造方法需要使用Mybatis_PageHelper插件进行分页.@see http://git.oschina.net/free/Mybatis_PageHelper ") ;
                PageInfo<T> pageInfo = new PageInfo<T>(rows);
                this.page = String.valueOf(pageInfo.getPageNum());  // 当前页数
                this.total = String.valueOf(pageInfo.getPages());   // 总页数
                this.rows = pageInfo.getList();                     // 实际数据list
                this.records = String.valueOf(pageInfo.getTotal());// 总条数
            }else {
                this.page = "1";
                this.total = "";
                this.records = "";
                this.rows = rows;
            }
        }

        /**
         * <P>返回完全可用的JqGridData,不需要关注分页属性值设置.</P>
         * #author palm
         * @param page
         * @param rows 数据
         */
        public JqGridData(String page, List<T> rows) {

            if (StringUtils.isBlank(page)) {
                page = "1" ;
            }

            if (rows instanceof Page) {
                PageInfo<T> pageInfo = new PageInfo<T>(rows);
                this.page  = String.valueOf(pageInfo.getPageNum()) ;
                this.total = String.valueOf(pageInfo.getPages()) ;
                this.rows = pageInfo.getList() ;
                this.records = String.valueOf(pageInfo.getTotal()) ;
            }else {
                this.page = page;
                this.total = "";
                this.records = "";
                this.rows = rows;
            }
        }

        public JqGridData(String page, String total, String records, List<T> rows) {
            this.page = page;
            this.total = total;
            this.records = records;
            this.rows = rows;
        }

        public String getPage() {
            return page;
        }

        public void setPage(String page) {
            this.page = page;
        }

        public String getTotal() {
            return total;
        }

        public void setTotal(String total) {
            this.total = total;
        }

        public String getRecords() {
            return records;
        }

        public void setRecords(String records) {
            this.records = records;
        }

        public List<T> getRows() {
            return rows;
        }

        public void setRows(List<T> rows) {
            if (rows instanceof Page) {
                PageInfo<T> pageInfo = new PageInfo<T>(rows);
                this.page = String.valueOf(pageInfo.getPageNum());
                this.total = String.valueOf(pageInfo.getPages());
                this.rows = pageInfo.getList();
                this.records = String.valueOf(pageInfo.getTotal());
            }else {
                this.rows = rows;
            }
        }


        @Override
        public String toString() {
            return "JqGridData{" +
                    "page='" + page + '\'' +
                    ", total='" + total + '\'' +
                    ", records='" + records + '\'' +
                    ", rows=" + rows +
                    '}';
        }
    }



