package cc.lechun.framework.common.utils.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import org.springframework.stereotype.Component;

@Component
public class DBFilter extends Filter<LoggingEvent> {
	@Override
	public FilterReply decide(LoggingEvent eventObject) {
		if(eventObject.getLevel().toInt() == Level.INFO.toInt()){
			if (eventObject.getMarker() == null){
				return FilterReply.DENY;
			}else if(eventObject.getMarker().toString().equals("SQL")){
				return FilterReply.ACCEPT;
			}else {
				return FilterReply.DENY;
			}

		}else {
			return FilterReply.DENY;
		}

	}
}
