package cc.lechun.framework.common.enums.quartz;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2017/12/13
 * Description:
 */
public enum QuartzTriggerGroupEnum {

    DEFAULT_GROUP("DEFAULT", "默认分组");

    private String value;
    private String name;

    /**
     * 获取列表
     */
    public static List<QuartzTriggerGroupEnum> getList() {
        return Arrays.asList(QuartzTriggerGroupEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(String value) {
        QuartzTriggerGroupEnum[] ls = QuartzTriggerGroupEnum.values();
        for (QuartzTriggerGroupEnum rs : ls) {
            if (rs.getValue().equals(value)) {
                return rs.getName();
            }
        }
        return "";
    }

    QuartzTriggerGroupEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
