package cc.lechun.framework.common.enums.customer;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/1/22
 * Description:地址类型
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CustomerAddressTypeEnum {

    zhuzhao(1, "住宅"),
    gongsi(2, "公司"),
    pengyou(3, "朋友"),
    jiaren(4, "家人"),
    xuexiao(5, "学校"),
    qita(6, "其他");

    /**
     * 获取列表
     */
    public static List<CustomerAddressTypeEnum> getList() {
        return Arrays.asList(CustomerAddressTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        CustomerAddressTypeEnum[] ls = CustomerAddressTypeEnum.values();
        for (CustomerAddressTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    private int value;
    private String name;

    CustomerAddressTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
