package cc.lechun.framework.common.utils.math;

import java.math.BigDecimal;

/**
 * 价格计算工具，四舍五入两位小数计算
 * Created by anyhow on 2018/2/10.
 */
public class PriceUtils {
    public static final Integer SCALE = 2;//小数保留位数
    public static final Integer PAYAMOUNT_SCALE = 6;//payAmount小数保留位数
    public static final Integer ROUND_STRATEGY = BigDecimal.ROUND_HALF_UP;//四舍五入
    public static BigDecimal format(Float price){
        return new BigDecimal(price).setScale(SCALE,ROUND_STRATEGY);
    }
    public static BigDecimal format(Double price){
        return new BigDecimal(price).setScale(SCALE,ROUND_STRATEGY);
    }
    public static BigDecimal format(BigDecimal price){
        return price.setScale(SCALE,ROUND_STRATEGY);
    }
    public static BigDecimal format(String price) {
        return new BigDecimal(price).setScale(SCALE,ROUND_STRATEGY);
    }
    public static BigDecimal add(BigDecimal param1, BigDecimal param2){
        if(param1==null){
            param1=new BigDecimal(0);
        }
        if(param2==null){
            param2=new BigDecimal(0);
        }
//        param1 = param1.setScale(SCALE,ROUND_STRATEGY);
//        param2 = param2.setScale(SCALE,ROUND_STRATEGY);
        return param1.add(param2).setScale(SCALE,ROUND_STRATEGY);
    }

    /**
     * 保留六位小数
     * @param param1
     * @param param2
     * @return
     */
    public static BigDecimal addNoUp(BigDecimal param1, BigDecimal param2){
        if(param1==null){
            param1=new BigDecimal(0);
        }
        if(param2==null){
            param2=new BigDecimal(0);
        }
        return param1.add(param2).setScale(PAYAMOUNT_SCALE,ROUND_STRATEGY);
    }

    public static BigDecimal subtract(BigDecimal param1, BigDecimal param2){
        if(param1==null){
            param1=new BigDecimal(0);
        }
        if(param2==null){
            param2=new BigDecimal(0);
        }
//        param1 = param1.setScale(SCALE,ROUND_STRATEGY);
//        param2 = param2.setScale(SCALE,ROUND_STRATEGY);
        return param1.subtract(param2).setScale(SCALE,ROUND_STRATEGY);
    }

    /**
     * 保留六位小数
     * @param param1
     * @param param2
     * @return
     */
    public static BigDecimal subtractToSix(BigDecimal param1, BigDecimal param2){
        if(param1==null){
            param1=new BigDecimal(0);
        }
        if(param2==null){
            param2=new BigDecimal(0);
        }
        return param1.subtract(param2).setScale(PAYAMOUNT_SCALE,ROUND_STRATEGY);
    }

    public static BigDecimal multiply(BigDecimal param1, BigDecimal param2){
        if(param1==null){
            param1=new BigDecimal(0);
        }
        if(param2==null){
            param2=new BigDecimal(0);
        }
//        param1 = param1.setScale(SCALE,ROUND_STRATEGY);
//        param2 = param2.setScale(SCALE,ROUND_STRATEGY);
        return param1.multiply(param2).setScale(PAYAMOUNT_SCALE,ROUND_STRATEGY);
    }
    public static BigDecimal multiply(BigDecimal param1, Integer param2){
        if(param1==null){
            param1=new BigDecimal(0);
        }
        if(param2==null){
            param2=0;
        }
//        param1 = param1.setScale(SCALE,ROUND_STRATEGY);
        BigDecimal _param2 = new BigDecimal(param2).setScale(SCALE,ROUND_STRATEGY);
        return param1.multiply(_param2).setScale(SCALE,ROUND_STRATEGY);
    }
    public static BigDecimal divide(BigDecimal param1, BigDecimal param2){
        if(param1==null){
            param1=new BigDecimal(0);
        }
        if(param2==null){
            param2=new BigDecimal(0);
        }
//        param1 = param1.setScale(SCALE,ROUND_STRATEGY);
//        param2 = param2.setScale(SCALE,ROUND_STRATEGY);
        return param1.divide(param2,SCALE,BigDecimal.ROUND_HALF_UP).setScale(SCALE,ROUND_STRATEGY);
    }
    public static BigDecimal divide(BigDecimal param1, BigDecimal param2,int scale,Integer roundStrategy){
        if(param1==null){
            param1=new BigDecimal(0);
        }
        if(param2==null){
            param2=new BigDecimal(0);
        }
//        param1 = param1.setScale(SCALE,ROUND_STRATEGY);
//        param2 = param2.setScale(SCALE,ROUND_STRATEGY);
        return param1.divide(param2,scale,roundStrategy).setScale(scale,roundStrategy);
    }
    public static String parse(BigDecimal totalAmount) {
        return PriceUtils.format(totalAmount).toString();
    }
}
