package cc.lechun.framework.common.utils.open.map.vo;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * Created by wangxs on 2017/12/22
 * Description: 地理编码返回类
 */
public class AMapGeoResultVo extends AMapResultVo {

    private static final long serialVersionUID = 1L;

    private List<AMapGocodese> geocodes;

    public List<AMapGocodese> getGeocodes() {
        return geocodes;
    }

    public void setGeocodes(List<AMapGocodese> geocodes) {
        this.geocodes = geocodes;
    }

    class AMapGocodese implements Serializable {

        private static final long serialVersionUID = 1L;
        private String formatted_address;//结构化地址信息省份＋城市＋区县＋城镇＋乡村＋街道＋门牌号码
        private String province;//地址所在的省份名例如：北京市。此处需要注意的是，中国的四大直辖市也算作省级单位。
        private String city;//地址所在的城市名例如：北京市
        private String citycode;//城市编码例如：010
        private String district;//地址所在的区例如：朝阳区
        private String township;//地址所在的乡镇例如：庞各庄镇
        private String street;//街道例如：阜通东大街
        private String number;//门牌例如：6号
        private String adcode;//区域编码例如：110101
        private String location;//坐标点经度，纬度
        private String level;//匹配级别参见下方的地理编码匹配级别列表
        private String longitude;//经度
        private String latitude;//纬度

        public String getFormatted_address() {
            return formatted_address;
        }

        public void setFormatted_address(String formatted_address) {
            this.formatted_address = formatted_address;
        }

        public String getProvince() {
            return province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getCitycode() {
            return citycode;
        }

        public void setCitycode(String citycode) {
            this.citycode = citycode;
        }

        public String getDistrict() {
            return district;
        }

        public void setDistrict(String district) {
            this.district = district;
        }

        public String getTownship() {
            return township;
        }

        public void setTownship(String township) {
            this.township = township;
        }

        public String getStreet() {
            return street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public String getNumber() {
            return number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getAdcode() {
            return adcode;
        }

        public void setAdcode(String adcode) {
            this.adcode = adcode;
        }

        public String getLocation() {
            return location;
        }

        public void setLocation(String location) {
            this.location = location;
            if (!StringUtils.isEmpty(location)) {
                String[] ls = location.split(",");
                this.longitude = ls[0];
                this.latitude = ls[1];
            }
        }

        public String getLevel() {
            return level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getLongitude() {
            return longitude;
        }

        public void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        public String getLatitude() {
            return latitude;
        }

        public void setLatitude(String latitude) {
            this.latitude = latitude;
        }

        @Override
        public String toString() {
            return "Gocodese{" +
                    "formatted_address='" + formatted_address + '\'' +
                    ", province='" + province + '\'' +
                    ", city='" + city + '\'' +
                    ", citycode='" + citycode + '\'' +
                    ", district='" + district + '\'' +
                    ", township='" + township + '\'' +
                    ", street='" + street + '\'' +
                    ", number='" + number + '\'' +
                    ", adcode='" + adcode + '\'' +
                    ", location='" + location + '\'' +
                    ", level='" + level + '\'' +
                    ", longitude='" + longitude + '\'' +
                    ", latitude='" + latitude + '\'' +
                    '}';
        }
    }
}
