/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.math;

import java.math.BigDecimal;

public class PriceUtils {
    public static final Integer SCALE = 2;
    public static final Integer PAYAMOUNT_SCALE = 6;
    public static final Integer ROUND_STRATEGY = 4;

    public static BigDecimal format(Float price) {
        return new BigDecimal(price.floatValue()).setScale((int)SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal format(Double price) {
        return new BigDecimal(price).setScale((int)SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal format(BigDecimal price) {
        return price.setScale((int)SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal format(String price) {
        return new BigDecimal(price).setScale((int)SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal add(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.add(param2).setScale((int)SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal addNoUp(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.add(param2).setScale((int)PAYAMOUNT_SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal subtract(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.subtract(param2).setScale((int)SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal subtractToSix(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.subtract(param2).setScale((int)PAYAMOUNT_SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal multiply(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.multiply(param2).setScale((int)PAYAMOUNT_SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal multiply(BigDecimal param1, Integer param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = 0;
        }
        BigDecimal _param2 = new BigDecimal(param2).setScale((int)SCALE, ROUND_STRATEGY);
        return param1.multiply(_param2).setScale((int)SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal divide(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.divide(param2, (int)SCALE, 4).setScale((int)SCALE, ROUND_STRATEGY);
    }

    public static BigDecimal divide(BigDecimal param1, BigDecimal param2, int scale, Integer roundStrategy) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.divide(param2, scale, roundStrategy).setScale(scale, roundStrategy);
    }

    public static String parse(BigDecimal totalAmount) {
        return PriceUtils.format(totalAmount).toString();
    }
}

