/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.http;

import cc.lechun.framework.common.utils.http.SslClient;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    private int connectTimeout = 15000;
    private int socketTimeout = 30000;
    private int connectionRequestTimeout = 5000;
    private String url = null;
    private String method = "GET";
    private Map<String, String> params;

    public HttpRequest(String url) {
        this.url = url;
    }

    public HttpRequest(String url, Map<String, String> params) {
        this.url = url;
        this.params = params;
    }

    public HttpRequest(String url, Object params) {
        this.url = url;
        this.params = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
    }

    public NameValuePair[] generatNameValuePair() {
        ArrayList<BasicNameValuePair> ls = new ArrayList<BasicNameValuePair>();
        Set<Map.Entry<String, String>> entrySet = this.params.entrySet();
        for (Map.Entry<String, String> e : entrySet) {
            String name = e.getKey();
            String value = e.getValue();
            BasicNameValuePair pair = new BasicNameValuePair(name, value);
            ls.add(pair);
        }
        return (NameValuePair[])ls.toArray(new BasicNameValuePair[ls.size()]);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsPost(String url, String param) {
        SslClient httpClient = null;
        HttpPost httpPost = null;
        String result = "";
        String charset = "utf-8";
        try {
            HttpEntity resEntity;
            httpClient = new SslClient();
            httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(param, "UTF-8"));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
        finally {
            httpClient = null;
            httpPost = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsPostByDeliver(String url, String param) {
        SslClient httpClient = null;
        HttpPost httpPost = null;
        String result = "";
        String charset = "utf-8";
        try {
            HttpEntity resEntity;
            httpClient = new SslClient();
            httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(param, "UTF-8"));
            httpPost.setHeader("Content-Type", "application/json");
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
        finally {
            httpClient = null;
            httpPost = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String wechatRefundHttps(String url, String param, String certFileName, String mchId) {
        keyStore = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            HttpRequest.log.error("", (Throwable)e);
        }
        instream = null;
        try {
            instream = new FileInputStream(new File(certFileName));
            keyStore.load(instream, mchId.toCharArray());
        }
        catch (IOException e) {
            HttpRequest.log.error("", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            HttpRequest.log.error("", (Throwable)e);
        }
        catch (CertificateException e) {
            HttpRequest.log.error("", (Throwable)e);
        }
        finally {
            try {
                instream.close();
            }
            catch (IOException e) {
                HttpRequest.log.error("", (Throwable)e);
            }
        }
        sslcontext = null;
        try {
            sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, mchId.toCharArray()).build();
        }
        catch (NoSuchAlgorithmException e) {
            HttpRequest.log.error("", (Throwable)e);
        }
        catch (KeyManagementException e) {
            HttpRequest.log.error("", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            HttpRequest.log.error("", (Throwable)e);
        }
        catch (KeyStoreException e) {
            HttpRequest.log.error("", (Throwable)e);
        }
        sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        try {
            httpost = new HttpPost("https://api.mch.weixin.qq.com/secapi/pay/refund");
            httpost.addHeader("Connection", "keep-alive");
            httpost.addHeader("Accept", "*/*");
            httpost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpost.addHeader("Host", "api.mch.weixin.qq.com");
            httpost.addHeader("X-Requested-With", "XMLHttpRequest");
            httpost.addHeader("Cache-Control", "max-age=0");
            httpost.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0) ");
            httpost.setEntity((HttpEntity)new StringEntity(param, "UTF-8"));
            System.out.println("executing request" + httpost.getRequestLine());
            response = null;
            try {
                response = httpclient.execute((HttpUriRequest)httpost);
            }
            catch (IOException e) {
                HttpRequest.log.error("", (Throwable)e);
            }
            try {
                entity = response.getEntity();
                text = "";
                System.out.println("----------------------------------------");
                System.out.println(response.getStatusLine());
                sb = "";
                if (entity != null) {
                    System.out.println("Response content length: " + entity.getContentLength());
                    bufferedReader = new BufferedReader(new InputStreamReader(entity.getContent()));
                    while ((text = bufferedReader.readLine()) != null) {
                        sb = sb + text;
                        System.out.println(text);
                    }
                }
                EntityUtils.consume((HttpEntity)entity);
                var14_32 = sb;
                return var14_32;
            }
            catch (IOException e) {
                ** try [egrp 16[TRYBLOCK] [29 : 698->756)] { 
            }
            finally {
                try {
                    response.close();
                }
                catch (IOException e) {
                    HttpRequest.log.error("", (Throwable)e);
                }
            }
lbl-1000:
            // 1 sources

            {
                catch (Throwable var18_37) {
                    throw var18_37;
                }
            }
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                HttpRequest.log.error("", (Throwable)e);
            }
        }
lbl97:
        // 1 sources

        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, String param) {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            String urlNameString = param.isEmpty() ? url : url + "?" + param;
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setRequestProperty("charset", "UTF-8");
            connection.setRequestProperty("referer", "http://wechat.lechun.cc");
            connection.setConnectTimeout(9900);
            connection.setReadTimeout(9900);
            connection.connect();
            Map<String, List<String>> map = connection.getHeaderFields();
            for (String key : map.keySet()) {
                System.out.println(key + "--->" + map.get(key));
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            log.error("post\u53c2\u6570" + url + "?" + param, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                log.error("", (Throwable)e2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String param) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("referer", "http://wechat.lechun.cc");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(1900);
            conn.setReadTimeout(1900);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            log.error("post\u53c2\u6570" + url + "?" + param, (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                log.error("", (Throwable)ex);
            }
        }
        return result;
    }
}

