/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.serviceresult;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtil {
    public static final String dateFormatter = "yyyy-MM-dd HH:mm:ss";
    public static final String date = "yyyy-MM-dd";

    public static String timestampToJavaDate(String seconds) {
        String pattern = "(\\d+)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(seconds);
        Long transSeconds = m.find() ? Long.parseLong(m.group(0).substring(0, m.group(0).length() - 3)) : 0L;
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatter);
        return sdf.format(new Date(transSeconds * 1000L));
    }

    public static Date getFormattedDate(String dateStr, String formatSr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(formatSr);
        return sdf.parse(dateStr);
    }

    public static String getFormattedString(Date date, String formatStr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        return sdf.format(date);
    }

    public static float getIntervalSeconds(String startDate, String endDate, String formatSr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatSr);
        long inervalSeconds = 0L;
        try {
            inervalSeconds = sdf.parse(endDate).getTime() - sdf.parse(startDate).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return Float.parseFloat(Long.toString(inervalSeconds / 1000L));
    }

    public static Date getSpecifiedDayBefore(Date specifiedDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(specifiedDate);
        int day = c.get(5);
        c.set(5, day - 1);
        return c.getTime();
    }

    public static Date getSpecifiedDayAfter(Date specifiedDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(specifiedDate);
        int day = c.get(5);
        c.set(5, day + 1);
        return c.getTime();
    }

    public static String getYesterdayTimeStart(Date nowDate, String formatStr) throws ParseException {
        Calendar cStart = Calendar.getInstance();
        cStart.setTime(nowDate);
        cStart.set(cStart.get(1), cStart.get(2), cStart.get(5) - 1, 0, 0, 0);
        return DateUtil.getFormattedString(cStart.getTime(), formatStr);
    }

    public static String getYesterdayTimeEnd(Date nowDate, String formatStr) throws ParseException {
        Calendar cEnd = Calendar.getInstance();
        cEnd.setTime(nowDate);
        cEnd.set(cEnd.get(1), cEnd.get(2), cEnd.get(5) - 1, 23, 59, 59);
        return DateUtil.getFormattedString(cEnd.getTime(), formatStr);
    }
}

