/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.springframework.web.servlet.ModelAndView;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BaseJsonVo<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SUCCESS_CODE = 200;
    public static final String SUCCESS_MESSAGE = "\u64cd\u4f5c\u6210\u529f";
    public static final int PARAM_CODE = 400;
    public static final String PARAM_MESSAGE = "\u53c2\u6570\u9519\u8bef";
    public static final int PARAM__CBARCODE_CODE = 405;
    public static final String PARAM__CBARCODE_CODE_MESSAGE = "\u7269\u54c1\u516d\u4e5d\u7801\u4e0d\u5b58\u5728";
    public static final int PARAM__LOGISTCS_TIME_CODE = 406;
    public static final String PARAM__LOGISTCS_TIME_CODE_MESSAGE = "\u7269\u6d41\u65f6\u6548\u914d\u7f6e\u4e0d\u5b58\u5728";
    public static final int PARAM__CAN_TSELL_CODE = 407;
    public static final String PARAM__CAN_TSELL_CODE_MESSAGE = "\u5e93\u5b58\u91cf\u4e0d\u8db3";
    public static final int NO_LOGIN_CODE = 20112;
    public static final String NO_LOGIN_MESSAGE = "\u5ba2\u6237\u7aef\u672a\u767b\u5f55\uff01";
    public static final int MINI_NO_LOGIN_CODE = 20113;
    public static final int NO_SECURITY_CODE = 403;
    public static final String NO_SECURITY_MESSAGE = "\u65e0\u6743\u9650\uff01";
    public static final int ERROR_CODE = 500;
    public static final String ERROR_MESSAGE = "\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
    public static final int ERROR_ACCOUNT_LOGIN_CODE = 410;
    public static final String ERROR_ACCOUNT_LOGIN_MESSAGE = "\u8d26\u6237\u9519\u8bef\uff01";
    public static final int ERROR_LOGIN_CODE = 106;
    public static final String ERROR_LOGIN_MESSAGE = "\u767b\u5f55\u9519\u8bef\uff01";
    public static final int SING_CODE = 40001;
    public static final String SIGN_MESSAGE = "\u9a8c\u8bc1\u5931\u8d25\uff01";
    public static final int ACTIVE_END_CODE = 40002;
    public static final String ACTIVE_END_MESSAGE = "\u6d3b\u52a8\u7ed3\u675f\uff01";
    public static final int PROMOTION_END_CODE = 40003;
    public static final String PROMOTION_END_MESSAGE = "\u4fc3\u9500\u672a\u5f00\u59cb\u6216\u5df2\u7ed3\u675f\uff01";
    public static final int EXCEEDED_LIMIT = 40004;
    public static final String EXCEEDED_LIMIT_MESSAGE = "\u8d85\u8fc7\u8d2d\u4e70\u6b21\u6570\u9650\u5236\uff01";
    public static final int HAS_UNPAY_ORDER = 40005;
    public static final String HAS_UNPAY_ORDER_MESSAGE = "\u5b58\u5728\u5f85\u4ed8\u6b3e\u8ba2\u5355\uff01";
    public static final int NO_PASSWORD = 100101;
    public static final int CITY_CLOSE = 1000;
    public static final String CITY_CLOS_MESSAGE = "\u57ce\u5e02\u5173\u95ed";
    public static final int DATE_ERROR = 1001;
    public static final String DATE_ERROR_MESSAGE = "\u914d\u9001\u65e5\u671f\u9519\u8bef";
    private int status;
    private String message;
    private long version = 1L;
    private T value;
    private long serverTime = System.currentTimeMillis();
    private Object result;
    private Integer error_code;
    private String error_msg;

    public static <T> BaseJsonVo success(T value) {
        return new BaseJsonVo<T>(200, SUCCESS_MESSAGE, value);
    }

    public static <T> BaseJsonVo success(String message, T value) {
        return new BaseJsonVo<T>(200, message, value);
    }

    public static <T> BaseJsonVo success(long version, T value) {
        return new BaseJsonVo<T>(200, SUCCESS_MESSAGE, version, value);
    }

    public static <T> BaseJsonVo error() {
        return new BaseJsonVo<T>(500, ERROR_MESSAGE);
    }

    public static <T> BaseJsonVo error(String message) {
        return new BaseJsonVo<T>(500, message);
    }

    public static <T> BaseJsonVo paramError(String message) {
        return new BaseJsonVo<T>(400, message);
    }

    public static <T> BaseJsonVo noLogin() {
        return new BaseJsonVo<T>(20112, NO_LOGIN_MESSAGE);
    }

    public static <T> BaseJsonVo miniNoLogin() {
        return new BaseJsonVo<T>(20113, NO_LOGIN_MESSAGE);
    }

    public static <T> BaseJsonVo errorLogin() {
        return new BaseJsonVo<T>(106, ERROR_LOGIN_MESSAGE);
    }

    public boolean isSuccess() {
        return this.status == 200;
    }

    public BaseJsonVo() {
        this.status = 200;
        this.message = SUCCESS_MESSAGE;
    }

    public BaseJsonVo(int status, String message) {
        this.status = status;
        this.message = message;
        if (200 != status) {
            this.error_code = status;
            this.error_msg = message;
        }
    }

    public BaseJsonVo(int status, String message, T value) {
        this.status = status;
        this.message = message;
        this.value = value;
        if (200 != status) {
            this.error_code = status;
            this.error_msg = message;
        }
    }

    public BaseJsonVo(int status, String message, long version, T value) {
        this.status = status;
        this.message = message;
        this.version = version;
        this.value = value;
        if (200 != status) {
            this.error_code = status;
            this.error_msg = message;
        }
    }

    public void addObject(ModelAndView mav) {
        mav.addObject("status", (Object)this.getStatus());
        mav.addObject("message", (Object)this.getMessage());
        mav.addObject("version", (Object)this.getVersion());
        mav.addObject("serverTime", (Object)this.getServerTime());
        mav.addObject("error_code", (Object)this.getError_code());
        mav.addObject("error_msg", (Object)this.getError_msg());
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        if (200 != status) {
            this.error_code = status;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public long getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(long serverTime) {
        this.serverTime = serverTime;
    }

    public String getError() {
        return this.error_msg;
    }

    public void setError(String error_msg) {
        this.status = 500;
        this.message = error_msg;
        this.error_code = 500;
        this.error_msg = error_msg;
    }

    public Integer getError_code() {
        return this.error_code;
    }

    public void setError_code(Integer error_code) {
        this.error_code = error_code;
    }

    public String getError_msg() {
        return this.error_msg;
    }

    public void setError_msg(String error_msg) {
        this.error_msg = error_msg;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }
}

