/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.exception;

import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.exception.MiniAuthorizeException;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.LoggerUtil;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.alibaba.fastjson.JSON;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class MyExceptionHandler
implements HandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(MyExceptionHandler.class);

    @ResponseBody
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        AccessLogEntity accessLog = LoggerUtil.getAccessLog(request);
        ModelAndView mav = new ModelAndView((View)new MappingJackson2JsonView());
        if (ex != null && ex instanceof MiniAuthorizeException) {
            BaseJsonVo.noLogin(ex.getMessage()).addObject(mav);
        } else if (ex != null && ex instanceof AuthorizeException) {
            BaseJsonVo.noLogin().addObject(mav);
        } else {
            log.error(JSON.toJSONString((Object)accessLog), (Throwable)ex);
            BaseJsonVo.error().addObject(mav);
        }
        return mav;
    }
}

