package cc.lechun.framework.common.enums.trade;

import cc.lechun.framework.common.vo.MallSelectDataVo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by anyhow on 2018/1/24.
 */
public enum SalesTypeEnum {

    SALES_ACTIVE(5, "活动"),
    SALES_PROMOTION(1, "促销"),
    SALES_GROUP(2, "套装"),
    SALES_PRODUCT(4, "单品");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<SalesTypeEnum> getList() {
        return Arrays.asList(SalesTypeEnum.values());
    }
    /**
     * 获取列表
     */
    public static List<MallSelectDataVo> getSelectDataList() {
        SalesTypeEnum[] ls = SalesTypeEnum.values();
        List<MallSelectDataVo> selectDataVos=new ArrayList<>();
        MallSelectDataVo selectDataVo;
        for (SalesTypeEnum rs : ls) {
            selectDataVo=new MallSelectDataVo();
            selectDataVo.setId(String.valueOf(rs.getValue()));
            selectDataVo.setName(rs.getName());
            selectDataVos.add(selectDataVo);
        }
        return selectDataVos;
    }
    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        SalesTypeEnum[] ls = SalesTypeEnum.values();
        for (SalesTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        SalesTypeEnum[] ls = SalesTypeEnum.values();
        for (SalesTypeEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    SalesTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "SalesTypeEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
