package cc.lechun.framework.common.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.web.servlet.ModelAndView;

import java.io.Serializable;

/**
 * 基础返回实体
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BaseJsonVo<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final int SUCCESS_CODE = 200;
    public static final String SUCCESS_MESSAGE = "操作成功";

    public static final int PARAM_CODE = 400;
    public static final String PARAM_MESSAGE = "参数错误";

    public static final int PARAM__CBARCODE_CODE = 405;
    public static final String PARAM__CBARCODE_CODE_MESSAGE = "物品六九码不存在";

    public static final int PARAM__LOGISTCS_TIME_CODE = 406;
    public static final String PARAM__LOGISTCS_TIME_CODE_MESSAGE = "物流时效配置不存在";
    public static final int PARAM__CAN_TSELL_CODE = 407;
    public static final String PARAM__CAN_TSELL_CODE_MESSAGE = "库存量不足";
    public static final int NO_LOGIN_CODE = 20112;
    public static final String NO_LOGIN_MESSAGE = "客户端未登录！";

    public static final int MINI_NO_LOGIN_CODE = 20113;

    public static final int NO_SECURITY_CODE = 403;
    public static final String NO_SECURITY_MESSAGE = "无权限！";

    public static final int ERROR_CODE = 500;
    public static final String ERROR_MESSAGE = "服务器繁忙，请稍后重试";

    public static final int ERROR_ACCOUNT_LOGIN_CODE = 410;
    public static final String ERROR_ACCOUNT_LOGIN_MESSAGE = "账户错误！";

    public static final int ERROR_LOGIN_CODE = 106;
    public static final String ERROR_LOGIN_MESSAGE = "登录错误！";

    public static final int SING_CODE = 40001;
    public static final String SIGN_MESSAGE = "验证失败！";

    public static final int ACTIVE_END_CODE = 40002;
    public static final String ACTIVE_END_MESSAGE = "活动结束！";

    public static final int PROMOTION_END_CODE = 40003;
    public static final String PROMOTION_END_MESSAGE = "促销未开始或已结束！";

    public static final int EXCEEDED_LIMIT = 40004;
    public static final String EXCEEDED_LIMIT_MESSAGE = "超过购买次数限制！";

    public static final int HAS_UNPAY_ORDER = 40005;
    public static final String HAS_UNPAY_ORDER_MESSAGE = "存在待付款订单！";


    public static final int NO_PASSWORD = 100101;

    public static  final int CITY_CLOSE=1000;
    public static final String CITY_CLOS_MESSAGE="城市关闭";

    public static final  int DATE_ERROR=1001;
    public static final  String DATE_ERROR_MESSAGE="配送日期错误";


    private int status;
    private String message;
    private long version = 1;
    private T value;
    //获取用户信息 0 不需要手机号和头像， 1 头像,2 手机，3 头像和手机都需要
    private int userInfoStatus=0;
    private long serverTime = System.currentTimeMillis();
    private Object result;

    //兼容老版本
    private Integer error_code;
    private String error_msg;


    public static <T> BaseJsonVo success(T value) {
        return new BaseJsonVo(SUCCESS_CODE, SUCCESS_MESSAGE, value);
    }

    public static <T> BaseJsonVo success(String message, T value) {
        return new BaseJsonVo(SUCCESS_CODE, message, value);
    }

    public static <T> BaseJsonVo success(String message, T value,int userInfoStatus) {
        return new BaseJsonVo(SUCCESS_CODE, message, value,userInfoStatus);
    }

    public static <T> BaseJsonVo success(long version, T value) {
        return new BaseJsonVo(SUCCESS_CODE, SUCCESS_MESSAGE, version, value);
    }

    public static <T> BaseJsonVo error() {
        return new BaseJsonVo(ERROR_CODE, ERROR_MESSAGE);
    }
    public static <T> BaseJsonVo error(String message) {
        return new BaseJsonVo(ERROR_CODE, message);
    }
    public static <T> BaseJsonVo paramError(String message) {
        return new BaseJsonVo(PARAM_CODE, message);
    }

    public static <T> BaseJsonVo noLogin(T value) {
        return new BaseJsonVo(MINI_NO_LOGIN_CODE, NO_LOGIN_MESSAGE,value);
    }

    public static <T> BaseJsonVo noLogin() {
        return new BaseJsonVo(NO_LOGIN_CODE, NO_LOGIN_MESSAGE);
    }

    public static <T> BaseJsonVo miniNoLogin() {
        return new BaseJsonVo(MINI_NO_LOGIN_CODE, NO_LOGIN_MESSAGE);
    }

    public static <T> BaseJsonVo errorLogin() {
        return new BaseJsonVo(ERROR_LOGIN_CODE, ERROR_LOGIN_MESSAGE);
    }

    public boolean isSuccess(){
        return status==SUCCESS_CODE;
    }

    public BaseJsonVo() {
        super();
        this.status = SUCCESS_CODE;
        this.message = SUCCESS_MESSAGE;
    }

    public BaseJsonVo(int status, String message) {
        super();
        this.status = status;
        this.message = message;
        if (SUCCESS_CODE != status) {
            this.error_code = status;
            this.error_msg = message;
        }
    }

    public BaseJsonVo(int status, String message, T value) {
        super();
        this.status = status;
        this.message = message;
        this.value = value;
        if (SUCCESS_CODE != status) {
            this.error_code = status;
            this.error_msg = message;
        }
    }

    public BaseJsonVo(int status, String message, T value,int userInfoStatus) {
        super();
        this.status = status;
        this.message = message;
        this.value = value;
        this.userInfoStatus=userInfoStatus;
        if (SUCCESS_CODE != status) {
            this.error_code = status;
            this.error_msg = message;
        }
    }

    public BaseJsonVo(int status, String message, long version, T value) {
        super();
        this.status = status;
        this.message = message;
        this.version = version;
        this.value = value;
        if (SUCCESS_CODE != status) {
            this.error_code = status;
            this.error_msg = message;
        }
    }

    public void addObject(ModelAndView mav) {
        mav.addObject("status", this.getStatus());
        mav.addObject("message", this.getMessage());
        mav.addObject("version", this.getVersion());
        mav.addObject("serverTime", this.getServerTime());
        mav.addObject("error_code", this.getError_code());
        mav.addObject("error_msg", this.getError_msg());
        mav.addObject("userInfoStatus", this.getUserInfoStatus());
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
        if (SUCCESS_CODE != status) {
            this.error_code = status;
        }
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getVersion() {
        return version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public T getValue() {
        return value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public long getServerTime() {
        return serverTime;
    }

    public void setServerTime(long serverTime) {
        this.serverTime = serverTime;
    }

    public String getError() {
        return error_msg;
    }

    public int getUserInfoStatus() {
        return userInfoStatus;
    }

    public void setUserInfoStatus(int userInfoStatus) {
        this.userInfoStatus = userInfoStatus;
    }

    public void setError(String error_msg) {
        this.status = ERROR_CODE;
        this.message = error_msg;
        this.error_code = ERROR_CODE;
        this.error_msg = error_msg;
    }

    public Integer getError_code() {
        return error_code;
    }

    public void setError_code(Integer error_code) {
        this.error_code = error_code;
    }

    public String getError_msg() {
        return error_msg;
    }

    public void setError_msg(String error_msg) {
        this.error_msg = error_msg;
    }

    public Object getResult() {
        return result;
    }

    public void setResult(Object result) {
        this.result = result;
    }
}
