/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.ids;

import cc.lechun.framework.common.utils.date.DateUtils;
import java.util.Random;

public class RandomUtils {
    private static final Random RANDOM = new Random();
    public static final String ALLCHAR = "23456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
    public static final String LETTERCHAR = "abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
    public static final String NUMBERCHAR = "0123456789";

    public static String generateRandomNumberString(int len) {
        Random random = new Random();
        StringBuilder buff = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            buff.append(random.nextInt(10));
        }
        return buff.toString();
    }

    public static synchronized long generateId() {
        return RandomUtils.generateId(DateUtils.nowMillis());
    }

    public static synchronized String generateStrId() {
        return String.valueOf(RandomUtils.generateId(DateUtils.nowMillis()));
    }

    public static synchronized long generateId(long timestamp) {
        return timestamp << 21 | (long)RANDOM.nextInt(0x200000);
    }

    public static String generateString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(ALLCHAR.charAt(random.nextInt(ALLCHAR.length())));
        }
        return sb.toString();
    }

    public static String generateNumString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(NUMBERCHAR.charAt(random.nextInt(NUMBERCHAR.length())));
        }
        return sb.toString();
    }

    public static String generateMixString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(LETTERCHAR.charAt(random.nextInt(LETTERCHAR.length())));
        }
        return sb.toString();
    }

    public static String generateLowerString(int length) {
        return RandomUtils.generateMixString(length).toLowerCase();
    }

    public static String generateUpperStringWithNum(int length) {
        return RandomUtils.generateString(length).toUpperCase();
    }

    public static String generateLowerStringWithNum(int length) {
        return RandomUtils.generateString(length).toLowerCase();
    }

    public static String generateUpperString(int length) {
        return RandomUtils.generateMixString(length).toUpperCase();
    }

    public static String generateZeroString(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public static String toFixdLengthString(long num, int fixdlenth) {
        StringBuffer sb = new StringBuffer();
        String strNum = String.valueOf(num);
        if (fixdlenth - strNum.length() >= 0) {
            sb.append(RandomUtils.generateZeroString(fixdlenth - strNum.length()));
        } else {
            strNum = strNum.substring(strNum.length() - fixdlenth);
        }
        sb.append(strNum);
        return sb.toString();
    }
}

