package cc.lechun.framework.common.enums.trade;

import cc.lechun.framework.common.vo.MallSelectDataVo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by anyhow on 2018/1/24.
 */
public enum TransportTypeEnum {

    LENG_LIAN(1, "冷链"),
    CHANG_WEN(2, "常温"),
    NO_DELIVERY(3, "线上兑换不配送");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<TransportTypeEnum> getList() {
        return Arrays.asList(TransportTypeEnum.values());
    }
    /**
     * 获取列表
     */
    public static List<MallSelectDataVo> getSelectDataList() {
        TransportTypeEnum[] ls = TransportTypeEnum.values();
        List<MallSelectDataVo> selectDataVos=new ArrayList<>();
        MallSelectDataVo selectDataVo;
        for (TransportTypeEnum rs : ls) {
            selectDataVo=new MallSelectDataVo();
            selectDataVo.setId(String.valueOf(rs.getValue()));
            selectDataVo.setName(rs.getName());
            selectDataVos.add(selectDataVo);
        }
        return selectDataVos;
    }
    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        TransportTypeEnum[] ls = TransportTypeEnum.values();
        for (TransportTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        TransportTypeEnum[] ls = TransportTypeEnum.values();
        for (TransportTypeEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    TransportTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "TransportTypeEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
