package cc.lechun.framework.common.utils.log;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by liqun on 2017/11/1.
 */
public class LogInterceptor implements HandlerInterceptor {

    private final Logger logger = LoggerFactory.getLogger("accessmonitor");
    public static final String LOG_OPERATE = "lechun.api.log";

    @Override
    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o){
        //把整个log中的参数，交给logUtil来获取，并返回log对象
        AccessLogEntity log = LoggerUtil.getAccessLog(httpServletRequest);
        httpServletRequest.setAttribute(LOG_OPERATE, log);
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
        /*logger.error("logger","dsafdsfas");*/
    }

    @Override
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        //返回视图时，插入操作日志
        AccessLogEntity log = (AccessLogEntity) httpServletRequest.getAttribute(LOG_OPERATE);
        long endTime = System.currentTimeMillis();
        log.setEndTime(endTime);
        log.setRunTimes(endTime - log.getBeginTime());
        String json = JSON.toJSONString(log, false);
        logger.info(json);
    }
}