package cc.lechun.framework.common.enums.platform;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/1/8
 * Description: 平台类型 1公众号 2小程序 3wap
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum PlatFormTypeEnum {
    ACCOUNT(1, "公众号"),
    MINI(2, "小程序"),
    WAP(3, "wap"),
    PC(4, "pc"),
    APP(5, "app");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<PlatFormTypeEnum> getList() {
        return Arrays.asList(PlatFormTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        PlatFormTypeEnum[] ls = PlatFormTypeEnum.values();
        for (PlatFormTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    PlatFormTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "PlatFormTypeEnum{" +
                "value=" + value +
                ", name='" + name + '\'' +
                '}';
    }
}
