package cc.lechun.framework.common.enums.trade;

import java.util.Arrays;
import java.util.List;

/**
 * Created by liqun on 2018/1/12.
 */
public enum  OrderStatusEnum {
    DELETE(-1, "已删除"),
    CANCEL(0, "已取消"),
    UNPAY(1, "待支付"),
    UNCONFIRM(2, "待确认"),
    PAYCONFIRM(3, "收款已确认"),
    COD_CONFIRM(4, "cod已确认"),
    EXPORT(5, "已导出"),
    PROCESS(6, "第三方生成成功"),
    DELIVING(7, "配货中"),
    PART_DELIVERED(9, "已部分发货"),
    DELIVERED(10, "已全部发货"),
    COD_PAYCONFIRM(11, "COD收款确认"),
    ARRIVED(12, "已送达"),
    TRADE_EXCEPTION(13, "交易异常终止"),
    PART_COMPLETION(15, "交易部分完成"),
    COMPLETION(16, "交易全部完成"),
    LOCK(18, "锁定"),
    RETURN_GOODS(20, "退货申请"),
    CHANGE_GOODS(21, "换货申请"),
    RETURN_PROCESS(22, "退货处理中"),
    CHANGE_PROCESS(23, "换货处理中"),
    REFUND_APPLY(25, "退款申请"),
    REFUND_PROCESS(26, "退款处理中"),
    REFUNDED(27, "已退款");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<OrderStatusEnum> getList() {
        return Arrays.asList(OrderStatusEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        OrderStatusEnum[] ls = OrderStatusEnum.values();
        for (OrderStatusEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static Integer getValue(String name) {
        OrderStatusEnum[] ls = OrderStatusEnum.values();
        for (OrderStatusEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return null;
    }
    OrderStatusEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "OrderStatusEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
