package cc.lechun.framework.common.utils.date;

import org.apache.commons.lang3.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 日期类型转换工具类
 * @author 梅开一片
 * @date 2016年5月3日下午1:26:52
 */
public final class DateFormatUtil {
	
	/**
	 * 默认的日期类型
	 */
	public static final String DEFAULT_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
	
	/**
	 * Date日期类型转换成 String 类型
	 * @author 梅开一片
	 * @date 2016年5月3日下午1:33:35
	 *
	 * @param date 要转换的日期
	 * @return
	 */
	public static String date2Str(Date date) {
		return date2Str(date, null);
	}
	
	/**
	 * Date日期类型转换成 String 类型
	 * @author 梅开一片
	 * @date 2016年5月3日下午1:33:35
	 *
	 * @param date 要转换的日期
	 * @param pattern 转换格式
	 * @return
	 */
	public static String date2Str(Date date, String pattern){
		if(date == null){
			return null;
		}
		if(StringUtils.isBlank(pattern)){
			pattern = DEFAULT_FORMAT_PATTERN;
		}
		SimpleDateFormat sdf = new SimpleDateFormat(pattern);
		return sdf.format(date);
	}
	
	/**
	 * String 类型日期转换成 Date类型
	 * @author 梅开一片
	 * @date 2016年5月3日下午1:41:24
	 *
	 * @param dateStr
	 * @return
	 * @throws ParseException
	 */
	public static Date str2Date(String dateStr) throws ParseException{
		return str2Date(dateStr, null);
	}
	
	/**
	 * String 类型日期转换成 Date类型
	 * @author 梅开一片
	 * @date 2016年5月3日下午1:41:56
	 *
	 * @param dateStr
	 * @param pattern
	 * @return
	 * @throws ParseException
	 */
	public static Date str2Date(String dateStr, String pattern) throws ParseException{
		if(StringUtils.isBlank(dateStr)){
			return null;
		}
		if(StringUtils.isBlank(pattern)){
			pattern = DEFAULT_FORMAT_PATTERN;
		}
		SimpleDateFormat sdf = new SimpleDateFormat(pattern);
		return sdf.parse(dateStr);
	}
}
