package cc.lechun.framework.common.utils.sign;

import cc.lechun.framework.common.utils.config.Config;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Base64Utils;

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.io.*;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;


public class AES {

	/** 密钥 */
	public static final String NAME = "name";
	public static final String PHONE = "phone";
	
	private static Map<String, Cipher> enCis = new HashMap<String, Cipher>();
	private static Map<String, Cipher> deCis = new HashMap<String, Cipher>();
	private static Map<String, SecretKey> deSecretKeys = new HashMap<String, SecretKey>();
	private static Map<String, SecretKey> enSecretKeys = new HashMap<String, SecretKey>();
 
	public static final String AES_KEY = "AES";
	public static final String CODE = "UTF-8";
	/**
	 * 当前是128位，如果需要大于196或256位的需要替换虚拟机的加密jar包
	 * 无特殊需要，不用替换
	 */
	public static final int BIT = 128;
	
	/**
	 * 生成密钥 
	 * @param filePath  密钥保存的路径和名称
	 */
	@SuppressWarnings("restriction")
	public static void generateKey(String filePath) {
		filePath = getFullPath(filePath);
		ObjectOutputStream outputStream = null;
		try {
			Security.addProvider(new com.sun.crypto.provider.SunJCE());
			// 实例化支持DES算法的密钥生成器(算法名称命名需按规定，否则抛出异常)
			KeyGenerator keygen = KeyGenerator.getInstance(AES_KEY);
			// 生成密钥
			SecretKey deskey = keygen.generateKey();
			outputStream = new ObjectOutputStream(new FileOutputStream(filePath));
			outputStream.writeObject(deskey);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				outputStream.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	/** 
	 * 获取加密文件路径 把秘钥存放在文件中
	 */
	private static String getFullPath(String filePath) {
		if (filePath.contains(".aes")) {
			return filePath;
		}
		return Config.value("aes_path") + filePath + ".aes";
	}
	
	/**
	 * 获取密钥
	 * 
	 * @param filePath
	 *            密钥文件路径
	 * @return
	 */ 
	public static SecretKey getEnSecretKey(String filePath) {
		filePath = getFullPath(filePath);
		SecretKey secretKey = enSecretKeys.get(filePath);
		if (secretKey != null) {
			return secretKey;
		}
		ObjectInputStream inputStream = null;
		try {
			inputStream = new ObjectInputStream(new FileInputStream(filePath));
			secretKey = (SecretKey) inputStream.readObject(); 
			enSecretKeys.put(filePath, secretKey);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				inputStream.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return secretKey;
	}
	
	/**
	 * 获取密钥
	 * 
	 * @param filePath
	 *            密钥文件路径
	 * @return
	 */ 
	public static SecretKey getDeSecretKey(String filePath) {
		filePath = getFullPath(filePath);
		SecretKey secretKey = deSecretKeys.get(filePath);
		if (secretKey != null) {
			return secretKey;
		}
		ObjectInputStream inputStream = null;
		try {
			inputStream = new ObjectInputStream(new FileInputStream(filePath));
			secretKey = (SecretKey) inputStream.readObject();
			deSecretKeys.put(filePath, secretKey);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				inputStream.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return secretKey;
	}
	
	/**
	 * 加密 
	 * @param key   密钥
	 * @param str 要加密的文本 
	 */
	public static String encrytor(String key, String str) {
		if (StringUtils.isEmpty(str)) {
			return str;
		}
		key = getFullPath(key); 
		synchronized (key) {
			try {
				byte[] src = str.getBytes();
				// 加密，结果保存进cipherByte
				byte[] cipherByte = getEnCi(key).doFinal(src);
				return Base64Utils.encodeToString(cipherByte);
			} catch (Exception e) {
 				e.printStackTrace();
			}
			return null;
		}
	}
	
	private static Cipher getEnCi(String filePath) {
		Cipher ci = enCis.get(filePath);
		if (ci != null) {
			return ci;
		}
		try {
			ci = Cipher.getInstance("AES");
			ci.init(Cipher.ENCRYPT_MODE, getEnSecretKey(filePath));
			enCis.put(filePath, ci);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ci;
	}
	/**
	 * 解密 
	 * @param key  密钥
	 * @param str 要解密的文本 
	 */
	public static String decryptor(String key, String str) {
		if (StringUtils.isEmpty(str)) {
			return str;
		}
		key = getFullPath(key);
		synchronized (key) {
			try {
				byte[] src = Base64Utils.decodeFromString(str);
				// 加密，结果保存进cipherByte
				byte[] cipherByte = getDeCi(key).doFinal(src);
				return new String(cipherByte);
			} catch (Exception e) {
 				e.printStackTrace();
				deCis.remove(key);
			}
			return null;
		}
	}

	private static Cipher getDeCi(String filePath) {
		Cipher ci = deCis.get(filePath);
		if (ci != null) {
			return ci;
		}
		try {
			ci = Cipher.getInstance("AES");
			ci.init(Cipher.DECRYPT_MODE, getDeSecretKey(filePath));
			deCis.put(filePath, ci);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return ci;
	}
	
	//上面是通过文件加密  下面通过一个字符串加密  代码实现是一样的
	
	/**
	 * 获取秘钥，如果 password 为null|""获取随机秘钥，不为空获取指定seed的秘钥
	 * @param password seed
	 * @return byte[] 秘钥字节数组
	 * @throws NoSuchAlgorithmException
	 */
	public static byte[] getSecretKey(String password) throws NoSuchAlgorithmException {
		KeyGenerator kgen;
		byte[] enCodeFormat = null;
		try {
			kgen = KeyGenerator.getInstance(AES.AES_KEY);
			if (StringUtils.isEmpty(password)) {
				kgen.init(AES.BIT);
			} else {
				kgen.init(AES.BIT, new SecureRandom(password.getBytes()));
			}
			SecretKey secretKey = kgen.generateKey();
			enCodeFormat = secretKey.getEncoded();
		} catch (NoSuchAlgorithmException e) {
			throw e;
		}
		return enCodeFormat;
	}
	/**
	 * 加密	 * 
	 * @param content 需要加密的内容
	 * @param password 加密KEY
	 * @return byte[]
	 * */
	public static byte[] encrypt(String content, String password) {
		byte[] result = null;
		try {
			byte[] enCodeFormat = AES.getSecretKey(password);
			SecretKeySpec key = new SecretKeySpec(enCodeFormat, AES.AES_KEY);
			Cipher cipher = Cipher.getInstance(AES.AES_KEY);
			byte[] byteContent = content.getBytes(AES.CODE);
			cipher.init(Cipher.ENCRYPT_MODE, key);
			result = cipher.doFinal(byteContent);
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (NoSuchPaddingException e) {
			e.printStackTrace();
		} catch (InvalidKeyException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IllegalBlockSizeException e) {
			e.printStackTrace();
		} catch (BadPaddingException e) {
			e.printStackTrace();
		}
		return result;
	}
	/**
	 * 解密
	 * @param content 待解密内容
	 * @param password 解密密钥
	 * @return byte[]
	 * */ 
	public static byte[] decrypt(byte[] content, String password) {
		byte[] result = null;
		try {
			byte[] enCodeFormat = AES.getSecretKey(password);
			SecretKeySpec key = new SecretKeySpec(enCodeFormat, AES.AES_KEY);
			Cipher cipher = Cipher.getInstance(AES.AES_KEY);
			cipher.init(Cipher.DECRYPT_MODE, key);
			result = cipher.doFinal(content);
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (NoSuchPaddingException e) {
			e.printStackTrace();
		} catch (InvalidKeyException e) {
			e.printStackTrace();
		} catch (IllegalBlockSizeException e) {
			e.printStackTrace();
		} catch (BadPaddingException e) {
			e.printStackTrace();
		}
		return result;
	}
	/**
	 * 加密字符串 
	 */
	public static String setEncrypt(String key,String content){
		String value = "";
		if (StringUtils.isNotEmpty(content)) {
			value = EncodeUtils.base64Encode(AES.encrypt(content, key));
		}
		return value;
	}
	
	/**
	 * 获取解密信息
	 * @param content 需解密的信息
	 * @param key 秘钥
	 * @return String
	 * @throws IOException 
	 */
	public static String getDecrypt(String key,String content){
		String value = "";
		if (StringUtils.isNotEmpty(content)) {
			value = new String(AES.decrypt(EncodeUtils.base64Decode(content), key));
		}
		return value;
	}
	
	
	

}
